/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity;

import com.mcmoddev.golems.entity.base.GolemBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.Particles;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class EntityTNTGolem
extends GolemBase {
    protected static final DataParameter<Boolean> DATA_IGNITED = EntityDataManager.func_187226_a(EntityTNTGolem.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final String ALLOW_SPECIAL = "Allow Special: Explode";
    protected final int minExplosionRad;
    protected final int maxExplosionRad;
    protected final int fuseLen;
    protected final int chanceToExplodeWhenAttacking;
    protected boolean allowedToExplode = false;
    protected boolean willExplode;
    protected int fuseTimer;

    public EntityTNTGolem(World world) {
        this(EntityTNTGolem.class, world, 4, 8, 50, 10);
        this.setLootTableLoc("golem_tnt");
        this.allowedToExplode = this.getConfigBool(ALLOW_SPECIAL);
    }

    public EntityTNTGolem(Class<? extends EntityTNTGolem> clazz, World world, int minExplosionRange, int maxExplosionRange, int minFuseLength, int randomExplosionChance) {
        super(clazz, world);
        this.minExplosionRad = minExplosionRange;
        this.maxExplosionRad = maxExplosionRange;
        this.fuseLen = minFuseLength;
        this.chanceToExplodeWhenAttacking = randomExplosionChance;
        this.resetIgnite();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_IGNITED, (Object)false);
    }

    @Override
    protected ResourceLocation applyTexture() {
        return EntityTNTGolem.makeTexture("golems", "golem_tnt");
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70027_ad()) {
            this.ignite();
        }
        if (this.func_70026_G() || this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) > (double)(this.minExplosionRad * this.maxExplosionRad)) {
            this.resetIgnite();
        }
        if (this.isIgnited()) {
            this.field_70179_y = 0.0;
            this.field_70159_w = 0.0;
            --this.fuseTimer;
            if (!this.field_70170_p.field_72995_K) {
                for (int i = 0; i < 2; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)Particles.field_197594_E, this.field_70165_t, this.field_70163_u + 2.0, this.field_70161_v, 0.0, 0.0, 0.0);
                    this.field_70170_p.func_195594_a((IParticleData)Particles.field_197594_E, this.field_70165_t + 0.75, this.field_70163_u + 1.0 + this.field_70146_Z.nextDouble() * 2.0, this.field_70161_v + 0.75, 0.5 * (0.5 - this.field_70146_Z.nextDouble()), 0.0, 0.5 * (0.5 - this.field_70146_Z.nextDouble()));
                    this.field_70170_p.func_195594_a((IParticleData)Particles.field_197594_E, this.field_70165_t + 0.75, this.field_70163_u + 1.0 + this.field_70146_Z.nextDouble() * 2.0, this.field_70161_v - 0.75, 0.5 * (0.5 - this.field_70146_Z.nextDouble()), 0.0, 0.5 * (0.5 - this.field_70146_Z.nextDouble()));
                    this.field_70170_p.func_195594_a((IParticleData)Particles.field_197594_E, this.field_70165_t - 0.75, this.field_70163_u + 1.0 + this.field_70146_Z.nextDouble() * 2.0, this.field_70161_v + 0.75, 0.5 * (0.5 - this.field_70146_Z.nextDouble()), 0.0, 0.5 * (0.5 - this.field_70146_Z.nextDouble()));
                    this.field_70170_p.func_195594_a((IParticleData)Particles.field_197594_E, this.field_70165_t - 0.75, this.field_70163_u + 1.0 + this.field_70146_Z.nextDouble() * 2.0, this.field_70161_v - 0.75, 0.5 * (0.5 - this.field_70146_Z.nextDouble()), 0.0, 0.5 * (0.5 - this.field_70146_Z.nextDouble()));
                }
            }
            if (this.fuseTimer <= 0) {
                this.willExplode = true;
            }
        }
        if (this.willExplode) {
            this.explode();
        }
    }

    @Override
    public void func_70645_a(DamageSource source) {
        super.func_70645_a(source);
        this.explode();
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        boolean flag = super.func_70652_k(entity);
        if (flag && entity.func_70089_S() && this.field_70146_Z.nextInt(100) < this.chanceToExplodeWhenAttacking && this.func_70068_e(entity) <= (double)(this.minExplosionRad * this.minExplosionRad)) {
            this.ignite();
        }
        return flag;
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (!itemstack.func_190926_b() && itemstack.func_77973_b() == Items.field_151033_d) {
            this.field_70170_p.func_184148_a(player, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187649_bu, this.func_184176_by(), 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
            player.func_184609_a(hand);
            if (!this.field_70170_p.field_72995_K) {
                this.func_70015_d(Math.floorDiv(this.fuseLen, 20));
                this.ignite();
                itemstack.func_77972_a(1, (EntityLivingBase)player);
            }
        }
        return super.func_184645_a(player, hand);
    }

    protected void resetFuse() {
        this.fuseTimer = this.fuseLen + this.field_70146_Z.nextInt(Math.floorDiv(this.fuseLen, 2) + 1);
    }

    protected void setIgnited(boolean toSet) {
        this.func_184212_Q().func_187227_b(DATA_IGNITED, (Object)toSet);
    }

    protected boolean isIgnited() {
        return (Boolean)this.func_184212_Q().func_187225_a(DATA_IGNITED);
    }

    protected void ignite() {
        if (!this.isIgnited()) {
            this.setIgnited(true);
            this.resetFuse();
            if (!this.func_70026_G()) {
                this.func_184185_a(SoundEvents.field_187572_ar, 0.9f, this.field_70146_Z.nextFloat());
            }
        }
    }

    protected void resetIgnite() {
        this.setIgnited(false);
        this.resetFuse();
        this.willExplode = false;
    }

    protected void explode() {
        if (this.allowedToExplode) {
            if (!this.field_70170_p.field_72995_K) {
                boolean flag = this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
                float range = this.maxExplosionRad > this.minExplosionRad ? (float)this.field_70146_Z.nextInt(this.maxExplosionRad - this.minExplosionRad) : (float)this.minExplosionRad;
                this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, range, flag);
                this.func_70106_y();
            }
        } else {
            this.resetIgnite();
        }
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187668_ca;
    }
}

