/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity;

import com.mcmoddev.golems.entity.base.GolemMultiTextured;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public final class EntityWoolGolem
extends GolemMultiTextured {
    public static final String WOOL_PREFIX = "wool";
    public static final String[] coloredWoolTypes = new String[]{"black", "orange", "magenta", "light_blue", "yellow", "lime", "pink", "gray", "silver", "cyan", "purple", "blue", "brown", "green", "red", "white"};
    private static final Map<Block, Byte> blockToTexture = new HashMap<Block, Byte>();
    private boolean secret = false;
    private byte[] iSecret = new byte[]{14, 1, 4, 5, 3, 11, 10, 2};

    public EntityWoolGolem(World world) {
        super(EntityWoolGolem.class, world, WOOL_PREFIX, coloredWoolTypes);
        this.setCanSwim(true);
    }

    @Override
    public String getModId() {
        return "golems";
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187554_ai;
    }

    @Override
    public void setTextureNum(byte toSet, boolean updateInstantly) {
        toSet = (byte)(toSet % (byte)(coloredWoolTypes.length - 1));
        super.setTextureNum(toSet, updateInstantly);
    }

    @Override
    public void onBuilt(IBlockState body, IBlockState legs, IBlockState arm1, IBlockState arm2) {
        byte textureNum = blockToTexture.containsKey(body.func_177230_c()) ? blockToTexture.get(body.func_177230_c()) : (byte)this.field_70146_Z.nextInt(coloredWoolTypes.length);
        this.setTextureNum(textureNum);
    }

    private static String getRainbowString(String stringIn, long timeIn) {
        String in = TextFormatting.func_110646_a((String)stringIn);
        StringBuilder stringOut = new StringBuilder(stringIn.length() * 2);
        int time = timeIn > 0x3FFFFFFFL ? 0x3FFFFFFF : (int)timeIn;
        TextFormatting[] colorChar = new TextFormatting[]{TextFormatting.RED, TextFormatting.GOLD, TextFormatting.YELLOW, TextFormatting.GREEN, TextFormatting.AQUA, TextFormatting.BLUE, TextFormatting.LIGHT_PURPLE, TextFormatting.DARK_PURPLE};
        int l = in.length();
        int cl = colorChar.length;
        for (int i = 0; i < l; ++i) {
            int meta = i + time;
            stringOut.append(colorChar[meta % cl] + "" + in.charAt(i));
        }
        return stringOut.toString();
    }

    static {
        blockToTexture.put(Blocks.field_196602_ba, (byte)0);
        blockToTexture.put(Blocks.field_196557_aM, (byte)1);
        blockToTexture.put(Blocks.field_196558_aN, (byte)2);
        blockToTexture.put(Blocks.field_196559_aO, (byte)3);
        blockToTexture.put(Blocks.field_196560_aP, (byte)4);
        blockToTexture.put(Blocks.field_196561_aQ, (byte)5);
        blockToTexture.put(Blocks.field_196562_aR, (byte)6);
        blockToTexture.put(Blocks.field_196563_aS, (byte)7);
        blockToTexture.put(Blocks.field_196564_aT, (byte)8);
        blockToTexture.put(Blocks.field_196565_aU, (byte)9);
        blockToTexture.put(Blocks.field_196566_aV, (byte)10);
        blockToTexture.put(Blocks.field_196567_aW, (byte)11);
        blockToTexture.put(Blocks.field_196568_aX, (byte)12);
        blockToTexture.put(Blocks.field_196569_aY, (byte)13);
        blockToTexture.put(Blocks.field_196570_aZ, (byte)14);
        blockToTexture.put(Blocks.field_196556_aL, (byte)15);
    }
}

