/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity.base;

import com.mcmoddev.golems.entity.ai.EntityAIDefendAgainstMonsters;
import com.mcmoddev.golems.entity.base.GolemMultiColorized;
import com.mcmoddev.golems.entity.base.GolemMultiTextured;
import com.mcmoddev.golems.main.GolemItems;
import com.mcmoddev.golems.util.config.ExtraGolemsConfig;
import com.mcmoddev.golems.util.config.GolemContainer;
import com.mcmoddev.golems.util.config.GolemRegistrar;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveThroughVillage;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.Particles;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.village.Village;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;

public abstract class GolemBase
extends EntityCreature
implements IAnimal {
    protected static final DataParameter<Boolean> BABY = EntityDataManager.func_187226_a(GolemBase.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> PLAYER_CREATED = EntityDataManager.func_187226_a(GolemBase.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final String KEY_BABY = "isChild";
    private static final String KEY_PLAYER_CREATED = "isPlayerCreated";
    public static final int WANDER_DISTANCE = 64;
    protected int attackTimer;
    protected ResourceLocation textureLoc;
    protected ResourceLocation lootTableLoc;
    protected ItemStack creativeReturn;
    protected Village villageObj;
    protected boolean hasHome = false;
    private int homeCheckTimer = 180;
    protected double knockbackY = 0.4f;
    protected float criticalModifier = 2.25f;
    protected int criticalChance = 5;
    protected boolean takesFallDamage = false;
    protected boolean canDrown = false;
    protected boolean isLeashable = true;
    protected final GolemContainer container;
    protected EntityAIBase swimmingAI = new EntityAISwimming((EntityLiving)this);
    protected EntityAIBase wanderAvoidWater = null;
    protected EntityAIBase wander = null;

    public GolemBase(Class<? extends GolemBase> clazz, World world) {
        super(GolemBase.getGolemType(clazz), world);
        this.container = GolemRegistrar.getContainer(clazz);
        this.func_70105_a(1.4f, 2.9f);
        this.setCanTakeFallDamage(false);
        Block pickBlock = this.container.getPrimaryBuildingBlock();
        this.setCreativeReturn(pickBlock != null ? pickBlock : GolemItems.golemHead);
        this.setCanSwim(false);
        this.field_70728_aV = 4 + this.field_70146_Z.nextInt(8);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, this.getBaseMoveSpeed() * 4.0, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, this.getBaseMoveSpeed() * 3.75, 32.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveThroughVillage((EntityCreature)this, this.getBaseMoveSpeed() * 2.25, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, this.getBaseMoveSpeed() * 4.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIDefendAgainstMonsters(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 10, false, true, e -> e != null && IMob.field_175450_e.test(e) && !(e instanceof EntityCreeper)));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.setTextureType(this.applyTexture());
        this.func_184212_Q().func_187214_a(BABY, (Object)false);
        this.func_184212_Q().func_187214_a(PLAYER_CREATED, (Object)false);
    }

    protected void func_110147_ax() {
        GolemContainer golemContainer = GolemRegistrar.getContainer(((Object)((Object)this)).getClass());
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(golemContainer.getAttack());
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(golemContainer.getHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(golemContainer.getSpeed());
    }

    protected void func_70619_bc() {
        if (this.homeCheckTimer > 0) {
            --this.homeCheckTimer;
        } else {
            this.updateHomeVillage();
            this.homeCheckTimer = 180;
        }
        super.func_70619_bc();
    }

    protected int func_70682_h(int i) {
        return this.canDrown ? super.func_70682_h(i) : i;
    }

    public boolean func_184652_a(EntityPlayer player) {
        return this.isLeashable && super.func_184652_a(player);
    }

    protected void func_82167_n(Entity entityIn) {
        if (entityIn instanceof IMob && entityIn instanceof EntityLivingBase && !(entityIn instanceof EntityCreeper) && this.func_70681_au().nextInt(20) == 0) {
            this.func_70624_b((EntityLivingBase)entityIn);
        }
        super.func_82167_n(entityIn);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y > 2.500000277905201E-7 && this.field_70146_Z.nextInt(5) == 0) {
            int i = MathHelper.func_76128_c((double)this.field_70165_t);
            int j = MathHelper.func_76128_c((double)(this.field_70163_u - 0.2));
            int k = MathHelper.func_76128_c((double)this.field_70161_v);
            BlockPos pos = new BlockPos(i, j, k);
            IBlockState iblockstate = this.field_70170_p.func_180495_p(pos);
            if (!this.field_70170_p.func_175623_d(pos) && !iblockstate.func_185904_a().func_76224_d()) {
                this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(Particles.field_197611_d, iblockstate), this.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, this.func_174813_aQ().field_72338_b + 0.1, this.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0);
            }
        }
    }

    public boolean func_70686_a(Class<? extends EntityLivingBase> cls) {
        boolean isAttackablePlayer = EntityPlayer.class.isAssignableFrom(cls) && (!this.isPlayerCreated() || ExtraGolemsConfig.enableFriendlyFire());
        boolean isCreeper = cls == EntityCreeper.class;
        return !isCreeper && (isAttackablePlayer || super.func_70686_a(cls));
    }

    protected void func_70665_d(DamageSource source, float amount) {
        if (!this.func_180431_b(source)) {
            float adjusted = amount;
            if (this.func_70644_a(MobEffects.field_188425_z)) {
                adjusted *= 0.89f;
            } else if (this.func_70644_a(MobEffects.field_189112_A)) {
                adjusted *= 1.25f;
            }
            super.func_70665_d(source, adjusted);
        }
    }

    public boolean func_70652_k(Entity entity) {
        float VARIANCE = 0.8f;
        float multiplier = 1.0f;
        if (this.func_70644_a(MobEffects.field_188425_z)) {
            multiplier += 0.5f * this.criticalModifier;
        } else if (this.func_70644_a(MobEffects.field_189112_A)) {
            multiplier -= 0.65f;
        } else if (this.field_70146_Z.nextInt(100) < this.criticalChance) {
            multiplier = this.criticalModifier;
        }
        float currentAttack = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        float damage = multiplier * (currentAttack + (float)this.field_70146_Z.nextInt((int)currentAttack + 1) * 0.8f);
        this.attackTimer = 10;
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        boolean flag = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), damage);
        if (flag) {
            entity.field_70181_x += this.knockbackY;
            this.func_174815_a((EntityLivingBase)this, entity);
        }
        this.func_184185_a(this.getThrowSound(), 1.0f, 0.9f + this.field_70146_Z.nextFloat() * 0.2f);
        return flag;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte b) {
        if (b == 4) {
            this.attackTimer = 10;
            this.func_184185_a(this.getThrowSound(), 1.0f, 0.9f + this.field_70146_Z.nextFloat() * 0.2f);
        } else {
            super.func_70103_a(b);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        if (this.canTakeFallDamage()) {
            super.func_180430_e(distance, damageMultiplier);
        }
    }

    public int func_82143_as() {
        return this.canTakeFallDamage() ? super.func_82143_as() : 64;
    }

    protected void func_180429_a(BlockPos pos, IBlockState blockIn) {
        this.func_184185_a(this.getWalkingSound(), 0.76f, 0.9f + this.field_70146_Z.nextFloat() * 0.2f);
    }

    public boolean func_70692_ba() {
        return false;
    }

    public int func_70627_aG() {
        return 24000;
    }

    public boolean func_70648_aU() {
        return !this.canDrown;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return this.creativeReturn;
    }

    public void func_70645_a(DamageSource src) {
        if (!this.isPlayerCreated() && this.field_70717_bb != null && this.villageObj != null) {
            this.villageObj.modifyPlayerReputation(this.field_70717_bb.func_110124_au(), -5);
        }
        super.func_70645_a(src);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a(KEY_BABY, this.func_70631_g_());
        compound.func_74757_a(KEY_PLAYER_CREATED, this.isPlayerCreated());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setChild(compound.func_74767_n(KEY_BABY));
        this.setPlayerCreated(compound.func_74767_n(KEY_PLAYER_CREATED));
    }

    protected ResourceLocation func_184647_J() {
        return this.lootTableLoc;
    }

    public boolean updateHomeVillage() {
        int radius = 96;
        return this.updateHomeVillageInRange(new BlockPos((Entity)this), 96);
    }

    protected boolean updateHomeVillageInRange(BlockPos POS, int RADIUS) {
        this.villageObj = this.field_70170_p.func_175714_ae().func_176056_a(POS, RADIUS);
        if (this.villageObj != null) {
            BlockPos home = this.villageObj.func_180608_a();
            int wanderDistance = (int)((float)this.villageObj.func_75568_b() * 0.8f);
            this.func_175449_a(home, wanderDistance);
            return true;
        }
        return false;
    }

    public void onBuilt(IBlockState body, IBlockState legs, IBlockState arm1, IBlockState arm2) {
    }

    public void setLootTableLoc(ResourceLocation lootTable) {
        this.lootTableLoc = lootTable;
    }

    public void setLootTableLoc(String modid, String name) {
        this.setLootTableLoc(new ResourceLocation(modid, "entities/" + name));
    }

    public void setLootTableLoc(String name) {
        this.setLootTableLoc("golems", name);
    }

    public void setCreativeReturn(Block blockToReturn) {
        this.setCreativeReturn(new ItemStack((IItemProvider)blockToReturn, 1));
    }

    public void setCreativeReturn(ItemStack blockToReturn) {
        this.creativeReturn = blockToReturn;
    }

    public ItemStack getCreativeReturn() {
        return this.creativeReturn;
    }

    public float getBaseAttackDamage() {
        return (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b();
    }

    public double getBaseMoveSpeed() {
        return this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b();
    }

    public Village getVillage() {
        return this.villageObj;
    }

    public void setChild(boolean isChild) {
        this.func_184212_Q().func_187227_b(BABY, (Object)isChild);
    }

    public boolean func_70631_g_() {
        return (Boolean)this.func_184212_Q().func_187225_a(BABY);
    }

    public void setCanTakeFallDamage(boolean toSet) {
        this.takesFallDamage = toSet;
    }

    public boolean canTakeFallDamage() {
        return this.takesFallDamage;
    }

    public void setCanSwim(boolean canSwim) {
        this.func_70661_as().func_212239_d(canSwim);
        if (null == this.wander) {
            this.wander = new EntityAIWander((EntityCreature)this, this.getBaseMoveSpeed() * 2.25);
        }
        if (null == this.wanderAvoidWater) {
            this.wanderAvoidWater = new EntityAIWanderAvoidWater((EntityCreature)this, this.getBaseMoveSpeed() * 2.25);
        }
        if (canSwim) {
            this.field_70714_bg.func_85156_a(this.wanderAvoidWater);
            this.field_70714_bg.func_75776_a(0, this.swimmingAI);
            this.field_70714_bg.func_75776_a(5, this.wander);
        } else {
            this.field_70714_bg.func_85156_a(this.swimmingAI);
            this.field_70714_bg.func_85156_a(this.wander);
            this.field_70714_bg.func_75776_a(5, this.wanderAvoidWater);
        }
    }

    public void setPlayerCreated(boolean bool) {
        this.func_184212_Q().func_187227_b(PLAYER_CREATED, (Object)bool);
    }

    public boolean isPlayerCreated() {
        return (Boolean)this.func_184212_Q().func_187225_a(PLAYER_CREATED);
    }

    public void setImmuneToFire(boolean toSet) {
        this.field_70178_ae = toSet;
    }

    public boolean canInteractChangeTexture() {
        return ExtraGolemsConfig.enableTextureInteract() && (GolemMultiTextured.class.isAssignableFrom(((Object)((Object)this)).getClass()) || GolemMultiColorized.class.isAssignableFrom(((Object)((Object)this)).getClass()));
    }

    public boolean doesProvideLight() {
        return false;
    }

    public boolean doesProvidePower() {
        return false;
    }

    public GolemContainer getGolemContainer() {
        return this.container != null ? this.container : GolemRegistrar.getContainer(((Object)((Object)this)).getClass());
    }

    public ForgeConfigSpec.ConfigValue getConfigValue(String name) {
        return ExtraGolemsConfig.GOLEM_CONFIG.specials.get((Object)this.getGolemContainer().specialContainers.get((Object)name)).value;
    }

    public boolean getConfigBool(String name) {
        return (Boolean)this.getConfigValue(name).get();
    }

    public int getConfigInt(String name) {
        return (Integer)this.getConfigValue(name).get();
    }

    public double getConfigDouble(String name) {
        return (Double)this.getConfigValue(name).get();
    }

    @Nullable
    public static EntityType<GolemBase> getGolemType(Class<? extends GolemBase> golem) {
        return GolemRegistrar.getContainer(golem).entityType;
    }

    protected static String trans(String s, Object ... strings) {
        return I18n.func_135052_a((String)s, (Object[])strings);
    }

    public void setTextureType(ResourceLocation texturelocation) {
        this.textureLoc = texturelocation;
    }

    public ResourceLocation getTextureType() {
        return this.textureLoc;
    }

    public static ResourceLocation makeTexture(String TEXTURE) {
        return GolemBase.makeTexture("golems", TEXTURE);
    }

    public static ResourceLocation makeTexture(String MODID, String TEXTURE) {
        return new ResourceLocation(MODID + ":textures/entity/" + TEXTURE + ".png");
    }

    protected SoundEvent func_184639_G() {
        return this.getGolemSound();
    }

    protected SoundEvent getWalkingSound() {
        return this.getGolemSound();
    }

    public SoundEvent getThrowSound() {
        return this.getGolemSound();
    }

    protected SoundEvent func_184601_bQ(DamageSource ignored) {
        return this.getGolemSound();
    }

    protected SoundEvent func_184615_bR() {
        return this.getGolemSound();
    }

    protected abstract ResourceLocation applyTexture();

    public abstract SoundEvent getGolemSound();
}

