/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity.base;

import com.mcmoddev.golems.entity.base.GolemColorized;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public abstract class GolemMultiColorized
extends GolemColorized {
    protected static final DataParameter<Byte> DATA_TEXTURE = EntityDataManager.func_187226_a(GolemMultiColorized.class, (DataSerializer)DataSerializers.field_187191_a);
    protected static final String NBT_TEXTURE = "GolemTextureData";
    protected final int[] colors;
    protected final ResourceLocation[] lootTables;
    public static final int[] dyeColorArray = new int[]{0xF9FFFE, 16351261, 13061821, 3847130, 16701501, 8439583, 15961002, 4673362, 0x9D9D97, 1481884, 8991416, 3949738, 8606770, 6192150, 11546150, 0x1D1D21};

    public GolemMultiColorized(Class<? extends GolemMultiColorized> type, World world, @Nullable ResourceLocation base, @Nullable ResourceLocation overlay, int[] lColors) {
        super(type, world, 0L, base, overlay);
        this.colors = lColors;
        this.lootTables = new ResourceLocation[this.colors.length];
        int len = this.colors.length;
        for (int n = 0; n < len; ++n) {
            this.lootTables[n] = new ResourceLocation(this.getModId(), "entities/" + this.func_70022_Q().replaceAll(this.getModId() + ":", "") + "/" + n);
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(DATA_TEXTURE, (Object)0);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_190926_b() && this.canInteractChangeTexture()) {
            int incremented = (this.getTextureNum() + 1) % this.getColorArray().length;
            this.setTextureNum((byte)incremented);
            player.func_184609_a(hand);
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (DATA_TEXTURE.equals(key)) {
            this.updateTextureByData(this.getTextureNum());
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70173_aa == 2) {
            this.updateTextureByData(this.getTextureNum());
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74774_a(NBT_TEXTURE, (byte)this.getTextureNum());
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setTextureNum(nbt.func_74771_c(NBT_TEXTURE));
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return this.lootTables[this.getTextureNum() % this.lootTables.length];
    }

    public void setTextureNum(byte toSet) {
        this.func_184212_Q().func_187227_b(DATA_TEXTURE, (Object)toSet);
    }

    public int getTextureNum() {
        return ((Byte)this.func_184212_Q().func_187225_a(DATA_TEXTURE)).intValue();
    }

    public int[] getColorArray() {
        return this.colors;
    }

    protected void updateTextureByData(int data) {
        this.setColor(this.colors[data]);
    }

    public String getModId() {
        return "golems";
    }
}

