/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.events.handlers;

import com.mcmoddev.golems.blocks.BlockGolemHead;
import com.mcmoddev.golems.entity.base.GolemBase;
import com.mcmoddev.golems.util.config.ExtraGolemsConfig;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCarvedPumpkin;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFindEntityNearest;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.monster.AbstractIllager;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class GolemCommonEventHandler {
    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        EnumActionResult result;
        Block heldBlock;
        ItemStack stack = event.getItemStack();
        int prevCount = stack.func_190916_E();
        if (ExtraGolemsConfig.pumpkinBuildsGolems() && !event.isCanceled() && !stack.func_190926_b() && stack.func_77973_b() instanceof ItemBlock && (heldBlock = ((ItemBlock)stack.func_77973_b()).func_179223_d()) instanceof BlockCarvedPumpkin && event.getUseItem() != Event.Result.DENY && (result = stack.func_196084_a(new ItemUseContext(event.getEntityPlayer(), stack, event.getPos(), event.getFace(), (float)event.getHitVec().field_72450_a, (float)event.getHitVec().field_72448_b, (float)event.getHitVec().field_72449_c))) == EnumActionResult.SUCCESS) {
            if (event.getEntityPlayer().func_184812_l_()) {
                stack.func_190920_e(prevCount);
            }
            BlockPos pumpkinPos = event.getPos().func_177972_a(event.getFace());
            if (!(event.getWorld().func_180495_p(pumpkinPos).func_177230_c() instanceof BlockCarvedPumpkin)) {
                pumpkinPos = event.getPos();
            }
            if (event.getWorld().func_180495_p(pumpkinPos).func_177230_c() instanceof BlockCarvedPumpkin) {
                BlockGolemHead.trySpawnGolem(event.getWorld(), pumpkinPos);
            }
        }
    }

    @SubscribeEvent
    public void onLivingSpawned(EntityJoinWorldEvent event) {
        EntityLiving living;
        if (event.getEntity() instanceof EntityCreature) {
            EntityCreature creature = (EntityCreature)event.getEntity();
            if (GolemCommonEventHandler.creatureAttacksGolems(creature)) {
                for (EntityAITasks.EntityAITaskEntry entry : creature.field_70715_bh.field_75782_a) {
                    if (!(entry.field_75733_a instanceof EntityAIAttackGolem)) continue;
                    return;
                }
                creature.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIAttackGolem(creature));
            }
        } else if (event.getEntity() instanceof EntityLiving && GolemCommonEventHandler.livingAttacksGolems((EntityLivingBase)(living = (EntityLiving)event.getEntity()))) {
            living.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIFindEntityNearest(living, GolemBase.class));
        }
    }

    private static boolean creatureAttacksGolems(EntityCreature e) {
        return e instanceof AbstractSkeleton || e instanceof EntitySpider || e instanceof AbstractIllager || e instanceof EntityZombie && !(e instanceof EntityPigZombie);
    }

    private static boolean livingAttacksGolems(EntityLivingBase e) {
        return e instanceof EntitySlime;
    }

    private static final class EntityAIAttackGolem
    extends EntityAINearestAttackableTarget<GolemBase> {
        private EntityAIAttackGolem(EntityCreature creature) {
            super(creature, GolemBase.class, true);
        }
    }
}

