/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.gui;

import com.mcmoddev.golems.entity.base.GolemBase;
import com.mcmoddev.golems.entity.base.GolemMultiColorized;
import com.mcmoddev.golems.entity.base.GolemMultiTextured;
import com.mcmoddev.golems.util.config.ExtraGolemsConfig;
import com.mcmoddev.golems.util.config.GolemContainer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityType;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class GolemBookEntry {
    private final Block[] BLOCKS;
    private final String GOLEM_NAME;
    private ResourceLocation IMAGE = null;
    private final boolean MULTI_TEXTURE;
    private final boolean FIREPROOF = false;
    private final int HEALTH;
    private final float ATTACK;
    private final List<ITextComponent> SPECIALS = new ArrayList<ITextComponent>();

    public GolemBookEntry(@Nonnull GolemContainer container) {
        EntityType<GolemBase> golemType = container.entityType;
        this.GOLEM_NAME = golemType.func_210760_d();
        this.MULTI_TEXTURE = ExtraGolemsConfig.enableTextureInteract() && (GolemMultiTextured.class.isAssignableFrom(golemType.func_201760_c()) || GolemMultiColorized.class.isAssignableFrom(golemType.func_201760_c()));
        this.HEALTH = (int)container.getHealth();
        this.ATTACK = (float)container.getAttack();
        container.addDescription(this.SPECIALS);
        this.BLOCKS = container.getBuildingBlocks();
        String img = "golems:textures/gui/screenshots/".concat(golemType.getRegistryName().func_110623_a()).concat(".png");
        try {
            this.IMAGE = Minecraft.func_71410_x().func_195551_G().func_199002_a(new ResourceLocation(img)).func_199029_a();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getGolemName() {
        return GolemBookEntry.trans(this.GOLEM_NAME, new Object[0]);
    }

    public String getGolemNameRaw() {
        return this.GOLEM_NAME;
    }

    public boolean hasBlocks() {
        return this.BLOCKS != null && this.BLOCKS.length > 0;
    }

    public Block getBlock(int index) {
        return this.hasBlocks() ? this.BLOCKS[index % this.BLOCKS.length] : Blocks.field_150350_a;
    }

    public Block[] getBlocks() {
        return this.BLOCKS;
    }

    public String getBlockName(Block b) {
        return GolemBookEntry.trans(b.func_149739_a(), new Object[0]);
    }

    public float getAttack() {
        return this.ATTACK;
    }

    public int getDescriptionSize() {
        return this.SPECIALS.size();
    }

    public String getDescriptionPage() {
        return this.makePage();
    }

    public boolean hasImage() {
        return this.IMAGE != null;
    }

    @Nullable
    public ResourceLocation getImageResource() {
        return this.IMAGE;
    }

    private String makePage() {
        StringBuilder page = new StringBuilder();
        page.append("\n" + TextFormatting.GRAY + GolemBookEntry.trans("entitytip.health", new Object[0]) + ": " + TextFormatting.BLACK + this.HEALTH + TextFormatting.DARK_RED + " \u2764" + TextFormatting.BLACK);
        page.append("\n" + TextFormatting.GRAY + GolemBookEntry.trans("entitytip.attack", new Object[0]) + ": " + TextFormatting.BLACK + this.ATTACK + " \u2694\n");
        this.getClass();
        if (this.MULTI_TEXTURE) {
            page.append("\n" + TextFormatting.BLUE + GolemBookEntry.trans("entitytip.click_change_texture", new Object[0]));
        }
        for (ITextComponent s : this.SPECIALS) {
            page.append("\n" + s.func_150254_d().replaceAll(TextFormatting.WHITE.toString(), TextFormatting.BLACK.toString()));
        }
        return page.toString();
    }

    protected static String trans(String s, Object ... strings) {
        return I18n.func_135052_a((String)s, (Object[])strings);
    }
}

