/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.integration;

import com.mcmoddev.golems.entity.EntityBedrockGolem;
import com.mcmoddev.golems.entity.base.GolemBase;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public abstract class GolemDescriptionManager {
    protected boolean showSpecial = true;
    protected boolean showSpecialChild = false;
    protected boolean showMultiTexture = true;
    protected boolean showAttack = true;
    protected boolean showFireproof = true;
    protected boolean showKnockbackResist = false;

    public List<ITextComponent> getEntityDescription(GolemBase golem) {
        LinkedList<ITextComponent> list = new LinkedList<ITextComponent>();
        if (this.showAttack) {
            float attack = (float)((int)(golem.getBaseAttackDamage() * 10.0f)) / 10.0f;
            list.add(new TextComponentTranslation("entitytip.attack", new Object[0]).func_211708_a(TextFormatting.GRAY).func_150257_a((ITextComponent)new TextComponentString(": ")).func_150257_a(new TextComponentString(Float.toString(attack)).func_211708_a(TextFormatting.WHITE)));
        }
        if (this.showMultiTexture && golem.canInteractChangeTexture()) {
            list.add(new TextComponentTranslation("entitytip.click_change_texture", new Object[0]).func_211708_a(TextFormatting.BLUE));
        }
        if (this.showFireproof && golem.func_70045_F() && !(golem instanceof EntityBedrockGolem)) {
            list.add(new TextComponentTranslation("entitytip.is_fireproof", new Object[0]).func_211708_a(TextFormatting.GOLD));
        }
        if (this.showKnockbackResist && golem.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111125_b() > 0.8999) {
            list.add(new TextComponentTranslation("attribute.name.generic.knockbackResistance", new Object[0]).func_211708_a(TextFormatting.GRAY));
        }
        if (!golem.func_70631_g_() && this.showSpecial || golem.func_70631_g_() && this.showSpecialChild) {
            golem.getGolemContainer().addDescription(list);
        }
        return list;
    }

    protected static boolean isShiftDown() {
        return GuiScreen.func_146272_n();
    }
}

