/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.items;

import com.mcmoddev.golems.entity.EntityBedrockGolem;
import com.mcmoddev.golems.entity.base.GolemBase;
import com.mcmoddev.golems.util.config.ExtraGolemsConfig;
import com.mcmoddev.golems.util.config.GolemRegistrar;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Particles;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class ItemBedrockGolem
extends Item {
    public ItemBedrockGolem() {
        super(new Item.Properties().func_200916_a(ItemGroup.field_78026_f));
    }

    public EnumActionResult func_195939_a(ItemUseContext context) {
        World worldIn = context.func_195991_k();
        EntityPlayer player = context.func_195999_j();
        EnumFacing facing = context.func_196000_l();
        BlockPos pos = context.func_195995_a();
        ItemStack stack = context.func_195996_i();
        if (ExtraGolemsConfig.bedrockGolemCreativeOnly() && !player.field_71075_bZ.field_75098_d || facing == EnumFacing.DOWN) {
            return EnumActionResult.FAIL;
        }
        if (GolemRegistrar.getContainer(EntityBedrockGolem.class).isEnabled()) {
            IBlockState state = worldIn.func_180495_p(pos);
            BlockPos spawnPos = state.func_196952_d((IBlockReader)context.func_195991_k(), context.func_195995_a()).func_197766_b() ? pos : pos.func_177972_a(context.func_196000_l());
            EntityType<GolemBase> entitytype = GolemRegistrar.getContainer(EntityBedrockGolem.class).entityType;
            if (!worldIn.field_72995_K && entitytype != null) {
                entitytype.func_208049_a(worldIn, stack, player, spawnPos, true, !Objects.equals(pos, spawnPos) && facing == EnumFacing.UP);
                stack.func_190918_g(1);
            }
            ItemBedrockGolem.spawnParticles(worldIn, spawnPos.func_177958_n(), spawnPos.func_177956_o(), spawnPos.func_177952_p(), 0.12);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public static void spawnParticles(World world, double x, double y, double z, double motion) {
        if (world.field_72995_K) {
            for (int i1 = 60 + world.field_73012_v.nextInt(30); i1 > 0; --i1) {
                world.func_195594_a((IParticleData)Particles.field_197594_E, x + world.field_73012_v.nextDouble() - 0.5, y + world.field_73012_v.nextDouble() - 0.5, z + world.field_73012_v.nextDouble() - 0.5, world.field_73012_v.nextDouble() * motion, world.field_73012_v.nextDouble() * motion * 0.25 + 0.08, world.field_73012_v.nextDouble() * motion);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        String loreCreativeOnly = TextFormatting.RED + this.trans("tooltip.creative_only_item");
        tooltip.add((ITextComponent)this.wrap(loreCreativeOnly));
        if (GuiScreen.func_146272_n()) {
            tooltip.add((ITextComponent)this.wrap(I18n.func_135052_a((String)"tooltip.use_to_spawn", (Object[])new Object[]{this.trans("entity.golems.golem_bedrock")})));
            tooltip.add((ITextComponent)this.wrap(I18n.func_135052_a((String)"tooltip.use_on_existing", (Object[])new Object[]{this.trans("entity.golems.golem_bedrock")})));
            tooltip.add((ITextComponent)this.wrap(this.trans("tooltip.to_remove_it") + "."));
        } else {
            String lorePressShift = TextFormatting.GRAY + this.trans("tooltip.press") + " " + TextFormatting.YELLOW + this.trans("tooltip.shift").toUpperCase() + " " + TextFormatting.GRAY + this.trans("tooltip.for_more_details");
            tooltip.add((ITextComponent)this.wrap(lorePressShift));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private String trans(String s) {
        return I18n.func_135052_a((String)s, (Object[])new Object[0]);
    }

    @OnlyIn(value=Dist.CLIENT)
    private TextComponentString wrap(String s) {
        return new TextComponentString(s);
    }
}

