/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.proxies;

import com.mcmoddev.golems.entity.base.GolemBase;
import com.mcmoddev.golems.entity.base.GolemColorized;
import com.mcmoddev.golems.main.ExtraGolems;
import com.mcmoddev.golems.proxies.ProxyCommon;
import com.mcmoddev.golems.renders.RenderColoredGolem;
import com.mcmoddev.golems.renders.RenderGolem;
import com.mcmoddev.golems.util.BlockTagUtil;
import com.mcmoddev.golems.util.config.GolemRegistrar;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;

public final class ProxyClient
extends ProxyCommon {
    public static final IRenderFactory<GolemBase> FACTORY_TEXTURED_GOLEM = RenderGolem::new;
    public static final IRenderFactory<GolemColorized> FACTORY_COLORED_GOLEM = RenderColoredGolem::new;

    @Override
    public void registerListeners() {
        IResourceManager irr = Minecraft.func_71410_x().func_195551_G();
        if (irr instanceof IReloadableResourceManager) {
            ((IReloadableResourceManager)irr).func_199006_a(l -> {
                ExtraGolems.LOGGER.info("Reloaded Listener activated! Loading block tags...");
                BlockTagUtil.loadTags();
                if (BlockTagUtil.TAG_CONCRETE != null) {
                    ExtraGolems.LOGGER.info("From the listener: Loaded tag for Concrete:\n{ ");
                    BlockTagUtil.TAG_CONCRETE.func_199885_a().stream().map(e -> e.getRegistryName().toString()).forEach(e -> System.out.print(e + "\n"));
                    System.out.print(" }\n");
                } else {
                    ExtraGolems.LOGGER.info("From the listener: TAG_CONCRETE is null!");
                }
            });
        }
    }

    @Override
    public void registerEntityRenders() {
        GolemRegistrar.getContainers().forEach(container -> ProxyClient.registerEntityRender(container.entityType.func_201760_c()));
    }

    public static void registerEntityRender(Class<? extends GolemBase> clazz) {
        if (GolemColorized.class.isAssignableFrom(clazz)) {
            ProxyClient.registerColorized(clazz);
        } else {
            ProxyClient.registerTextured(clazz);
        }
    }

    public static void registerTextured(Class<? extends GolemBase> golem) {
        RenderingRegistry.registerEntityRenderingHandler(golem, FACTORY_TEXTURED_GOLEM);
    }

    public static void registerColorized(Class<? extends GolemColorized> golem) {
        RenderingRegistry.registerEntityRenderingHandler(golem, FACTORY_COLORED_GOLEM);
    }
}

