/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.util;

import com.mcmoddev.golems.entity.EntityConcreteGolem;
import com.mcmoddev.golems.entity.EntityMushroomGolem;
import com.mcmoddev.golems.entity.EntityStainedClayGolem;
import com.mcmoddev.golems.entity.EntityStainedGlassGolem;
import com.mcmoddev.golems.entity.EntityWoodenGolem;
import com.mcmoddev.golems.entity.EntityWoolGolem;
import java.util.function.Consumer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootTableList;

public class ConsumerLootTables
implements Consumer<String> {
    public static final ConsumerLootTables CONSUMER = new ConsumerLootTables();

    @Override
    public void accept(String NAME) {
        switch (NAME) {
            case "golem_bedrock": {
                return;
            }
            case "golem_wool": {
                ConsumerLootTables.registerLootTables("golems", NAME, EntityWoolGolem.coloredWoolTypes);
                return;
            }
            case "golem_wooden": {
                ConsumerLootTables.registerLootTables("golems", NAME, EntityWoodenGolem.woodTypes);
                return;
            }
            case "golem_shroom": {
                ConsumerLootTables.registerLootTables("golems", NAME, EntityMushroomGolem.SHROOM_TYPES);
                return;
            }
            case "golem_stained_glass": {
                ConsumerLootTables.registerLootTables("golems", NAME, EntityStainedGlassGolem.dyeColorArray.length);
                return;
            }
            case "golem_stained_clay": {
                ConsumerLootTables.registerLootTables("golems", NAME, EntityStainedClayGolem.dyeColorArray.length);
                return;
            }
            case "golem_concrete": {
                ConsumerLootTables.registerLootTables("golems", NAME, EntityConcreteGolem.dyeColorArray.length);
                return;
            }
        }
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("golems", "entities/" + NAME));
    }

    public static void registerLootTables(String MODID, String name, String[] textures) {
        for (String s : textures) {
            LootTableList.func_186375_a((ResourceLocation)new ResourceLocation(MODID, "entities/" + name + "/" + s));
        }
    }

    public static void registerLootTables(String MODID, String name, int max) {
        String[] array = new String[max];
        for (int i = 0; i < max; ++i) {
            array[i] = Integer.toString(i);
        }
        ConsumerLootTables.registerLootTables(MODID, name, array);
    }
}

