/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.util.config;

import com.mcmoddev.golems.util.config.GolemConfigurationSection;
import com.mcmoddev.golems.util.config.GolemContainer;
import com.mcmoddev.golems.util.config.GolemRegistrar;
import com.mcmoddev.golems.util.config.special.GolemSpecialContainer;
import com.mcmoddev.golems.util.config.special.GolemSpecialSection;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;

public class GolemConfiguration {
    public Map<GolemContainer, GolemConfigurationSection> sections = new HashMap<GolemContainer, GolemConfigurationSection>();
    public Map<GolemSpecialContainer, GolemSpecialSection> specials = new HashMap<GolemSpecialContainer, GolemSpecialSection>();
    public ForgeConfigSpec.BooleanValue bedrockGolemCreativeOnly;
    public ForgeConfigSpec.BooleanValue pumpkinBuildsGolem;
    public ForgeConfigSpec.BooleanValue enableFriendlyFire;
    public ForgeConfigSpec.BooleanValue enableTextureInteract;

    public GolemConfiguration(ForgeConfigSpec.Builder builder) {
        builder.push("general");
        this.bedrockGolemCreativeOnly = builder.comment("When true, only players in creative mode can use a Bedrock Golem spawn item").define("bedrock_golem_creative_only", true);
        this.pumpkinBuildsGolem = builder.comment("(Experimental) When true, pumpkins can be used to build this mod's golems").define("pumpkin_builds_golems", false);
        this.enableFriendlyFire = builder.comment("When enabled, attacking a player-built golem will make it attack you").define("friendly_fire", true);
        this.enableTextureInteract = builder.comment("When enabled, some golems will change their texture when clicked").define("texture_interact", false);
        builder.pop();
        for (GolemContainer c : GolemRegistrar.golemList.values()) {
            builder.push(c.getName());
            this.sections.put(c, new GolemConfigurationSection(c, builder));
            builder.push("specials");
            for (GolemSpecialContainer specialC : c.specialContainers.values()) {
                this.specials.put(specialC, new GolemSpecialSection(specialC, builder));
            }
            builder.pop(2);
        }
    }

    public void loadData() {
        for (Map.Entry<GolemContainer, GolemConfigurationSection> e : this.sections.entrySet()) {
            GolemContainer c = e.getKey();
            GolemConfigurationSection section = e.getValue();
            c.setAttack((Double)section.attack.get());
            c.setHealth((Double)section.health.get());
            for (GolemSpecialContainer specialC : c.specialContainers.values()) {
                specialC.value = this.specials.get((Object)specialC).value;
            }
        }
    }
}

