/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.util.config;

import com.mcmoddev.golems.entity.base.GolemBase;
import com.mcmoddev.golems.util.config.GolemDescription;
import com.mcmoddev.golems.util.config.special.GolemSpecialContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class GolemContainer {
    private final List<Block> validBuildingBlocks;
    private final List<ResourceLocation> validBuildingBlockTags;
    public final EntityType<GolemBase> entityType;
    private final String name;
    private double health;
    private double attack;
    private double speed;
    private boolean enabled = true;
    public final Map<String, GolemSpecialContainer> specialContainers;
    public final List<GolemDescription> descContainers;

    private GolemContainer(EntityType<GolemBase> lEntityType, String lPath, List<Block> lValidBuildingBlocks, List<ResourceLocation> lValidBuildingBlockTags, double lHealth, double lAttack, double lSpeed, HashMap<String, GolemSpecialContainer> lSpecialContainers, List<GolemDescription> lDescContainers) {
        this.entityType = lEntityType;
        this.validBuildingBlocks = lValidBuildingBlocks;
        this.validBuildingBlockTags = lValidBuildingBlockTags;
        this.name = lPath;
        this.health = lHealth;
        this.attack = lAttack;
        this.speed = lSpeed;
        this.specialContainers = lSpecialContainers;
        this.descContainers = lDescContainers;
    }

    public void addDescription(List<ITextComponent> list) {
        for (GolemDescription cont : this.descContainers) {
            cont.addDescription(list, this);
        }
    }

    public boolean hasBuildingBlock() {
        return !this.validBuildingBlocks.isEmpty() || !this.validBuildingBlockTags.isEmpty();
    }

    public Block[] getBuildingBlocks() {
        HashSet<Block> blocks = new HashSet<Block>();
        blocks.addAll(this.validBuildingBlocks);
        for (Tag<Block> tag : GolemContainer.loadTags(this.validBuildingBlockTags)) {
            blocks.addAll(tag.func_199885_a());
        }
        return blocks.toArray(new Block[0]);
    }

    public boolean isBuildingBlock(Block b) {
        if (null == b) {
            return false;
        }
        if (this.validBuildingBlocks.contains(b)) {
            return true;
        }
        for (Tag<Block> tag : GolemContainer.loadTags(this.validBuildingBlockTags)) {
            if (!b.func_203417_a(tag)) continue;
            return true;
        }
        return false;
    }

    public boolean areBuildingBlocks(Block b1, Block b2, Block b3, Block b4) {
        return this.isBuildingBlock(b1) && this.isBuildingBlock(b2) && this.isBuildingBlock(b3) && this.isBuildingBlock(b4);
    }

    @Nullable
    public Block getPrimaryBuildingBlock() {
        if (this.hasBuildingBlock()) {
            if (!this.validBuildingBlocks.isEmpty() && this.validBuildingBlocks.get(0) != null) {
                return this.validBuildingBlocks.get(0);
            }
            if (!this.validBuildingBlockTags.isEmpty() && this.validBuildingBlockTags.get(0) != null) {
                Block[] blocks = BlockTags.func_199896_a().func_199910_a(this.validBuildingBlockTags.get(0)).func_199885_a().toArray(new Block[0]);
                return blocks.length > 0 ? blocks[0] : null;
            }
        }
        return null;
    }

    public boolean addBlocks(Block ... additional) {
        return additional.length > 0 && this.validBuildingBlocks.addAll(Arrays.asList(additional));
    }

    public boolean addBlocks(@Nonnull Tag<Block> additional) {
        return this.validBuildingBlockTags.add(additional.func_199886_b());
    }

    private static Collection<Tag<Block>> loadTags(Collection<ResourceLocation> rls) {
        HashSet<Tag<Block>> tags = new HashSet<Tag<Block>>();
        rls.forEach(rl -> tags.add(BlockTags.func_199896_a().func_199910_a(rl)));
        return tags;
    }

    public void setHealth(double pHealth) {
        this.health = pHealth;
    }

    public void setAttack(double pAttack) {
        this.attack = pAttack;
    }

    public void setSpeed(double pSpeed) {
        this.speed = pSpeed;
    }

    public void setEnabled(boolean pEnabled) {
        this.enabled = pEnabled;
    }

    public EntityType<GolemBase> getEntityType() {
        return this.entityType;
    }

    public String getName() {
        return this.name;
    }

    public double getHealth() {
        return this.health;
    }

    public double getAttack() {
        return this.attack;
    }

    public double getSpeed() {
        return this.speed;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public static final class Builder {
        private final String golemName;
        private final EntityType.Builder<GolemBase> entityTypeBuilder;
        private String modid = "golems";
        private double health = 100.0;
        private double attack = 14.0;
        private double speed = 0.25;
        private List<Block> validBuildingBlocks = new ArrayList<Block>();
        private List<ResourceLocation> validBuildingBlockTags = new ArrayList<ResourceLocation>();
        private List<GolemSpecialContainer> specials = new ArrayList<GolemSpecialContainer>();
        private List<GolemDescription> descriptions = new ArrayList<GolemDescription>();

        public Builder(String golemName, Class<? extends GolemBase> entityClazz, Function<? super World, ? extends GolemBase> entityFunction) {
            this.golemName = golemName;
            this.entityTypeBuilder = EntityType.Builder.func_201757_a(entityClazz, entityFunction).tracker(48, 3, true);
        }

        public Builder setModId(String lModId) {
            this.modid = lModId;
            return this;
        }

        public Builder setHealth(double lHealth) {
            this.health = lHealth;
            return this;
        }

        public Builder setAttack(double lAttack) {
            this.attack = lAttack;
            return this;
        }

        public Builder setSpeed(double lMoveSpeed) {
            this.speed = lMoveSpeed;
            return this;
        }

        public Builder addBlocks(Block ... additionalBlocks) {
            if (additionalBlocks != null && additionalBlocks.length > 0) {
                this.validBuildingBlocks.addAll(Arrays.asList(additionalBlocks));
            }
            return this;
        }

        public Builder addBlocks(Tag<Block> blockTag) {
            this.validBuildingBlockTags.add(blockTag.func_199886_b());
            return this;
        }

        public Builder addSpecials(GolemSpecialContainer ... specialContainers) {
            this.specials.addAll(Arrays.asList(specialContainers));
            return this;
        }

        public Builder addSpecial(String name, Object value, String comment) {
            this.specials.add(new GolemSpecialContainer.Builder<Object>(name, value, comment).build());
            return this;
        }

        public Builder addSpecial(String name, Boolean value, String comment, ITextComponent desc) {
            this.addSpecial(name, value, comment);
            this.addDesc(new GolemDescription(desc, name));
            return this;
        }

        public Builder addDesc(GolemDescription ... desc) {
            for (GolemDescription cont : desc) {
                this.descriptions.add(cont);
            }
            return this;
        }

        public GolemContainer build() {
            EntityType entityType = this.entityTypeBuilder.func_206830_a(this.golemName);
            entityType.setRegistryName(this.modid, this.golemName);
            HashMap<String, GolemSpecialContainer> containerMap = new HashMap<String, GolemSpecialContainer>();
            for (GolemSpecialContainer c : this.specials) {
                containerMap.put(c.name, c);
            }
            return new GolemContainer(entityType, this.golemName, this.validBuildingBlocks, this.validBuildingBlockTags, this.health, this.attack, this.speed, containerMap, this.descriptions);
        }
    }
}

