/*
 * Decompiled with CFR 0.152.
 */
package xyz.vsngamer.elevatorid.network;

import java.util.function.Supplier;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.vsngamer.elevatorid.blocks.BlockElevator;
import xyz.vsngamer.elevatorid.init.ModConfig;
import xyz.vsngamer.elevatorid.init.ModSounds;
import xyz.vsngamer.elevatorid.network.TeleportRequest;

public class TeleportHandler {
    static void handle(TeleportRequest message, Supplier<NetworkEvent.Context> ctx) {
        EntityPlayerMP player = ctx.get().getSender();
        if (player == null) {
            return;
        }
        World world = player.field_70170_p;
        BlockPos from = message.getFrom();
        BlockPos to = message.getTo();
        if (from.func_177958_n() != to.func_177958_n() || from.func_177952_p() != to.func_177952_p()) {
            return;
        }
        IBlockState fromState = world.func_180495_p(from);
        IBlockState toState = world.func_180495_p(to);
        if (!TeleportHandler.isElevator(fromState) || !TeleportHandler.isElevator(toState)) {
            return;
        }
        if (player.func_174831_c(from) > 5.0) {
            return;
        }
        if (!TeleportHandler.validateTarget((IBlockReader)world, to)) {
            return;
        }
        if (((Boolean)ModConfig.GENERAL.sameColor.get()).booleanValue() && fromState.func_177230_c() != toState.func_177230_c()) {
            return;
        }
        if (((Boolean)ModConfig.GENERAL.precisionTarget.get()).booleanValue()) {
            player.func_70634_a((double)((float)to.func_177958_n() + 0.5f), (double)(to.func_177956_o() + 1), (double)((float)to.func_177952_p() + 0.5f));
        } else {
            player.func_70634_a((double)(to.func_177958_n() - from.func_177958_n()) + player.field_70165_t, (double)(to.func_177956_o() - from.func_177956_o()) + player.field_70163_u, (double)(to.func_177952_p() - from.func_177952_p()) + player.field_70161_v);
        }
        player.field_70181_x = 0.0;
        world.func_184133_a(null, to, ModSounds.teleport, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    public static boolean validateTarget(IBlockReader world, BlockPos target) {
        return TeleportHandler.validateTarget(world.func_180495_p(target.func_177981_b(1))) && TeleportHandler.validateTarget(world.func_180495_p(target.func_177981_b(2)));
    }

    private static boolean validateTarget(IBlockState blockState) {
        return blockState.func_185904_a() == Material.field_151579_a || !blockState.func_185904_a().func_76230_c();
    }

    public static boolean isElevator(IBlockState blockState) {
        return blockState.func_177230_c() instanceof BlockElevator;
    }
}

