/*
 * Decompiled with CFR 0.152.
 */
package xyz.vsngamer.elevatorid.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import xyz.vsngamer.elevatorid.ElevatorModTab;
import xyz.vsngamer.elevatorid.init.ModConfig;

public abstract class AbstractElevator
extends Block {
    private DyeColor dyeColor;
    private ElevatorBlockItem item;

    AbstractElevator(DyeColor color) {
        super(Block.Properties.func_200952_a((Material)Material.field_151580_n, (DyeColor)color).func_200947_a(SoundType.field_185854_g).func_200943_b(0.8f));
        this.setReg(color);
        this.dyeColor = color;
    }

    abstract void setReg(DyeColor var1);

    public boolean canCreatureSpawn(BlockState state, IBlockReader world, BlockPos pos, EntitySpawnPlacementRegistry.PlacementType type, @Nullable EntityType<?> entityType) {
        return (Boolean)ModConfig.GENERAL.mobSpawn.get() != false && super.canCreatureSpawn(state, world, pos, type, entityType);
    }

    @Nonnull
    public Item func_199767_j() {
        if (this.item == null) {
            this.item = new ElevatorBlockItem();
        }
        return this.item;
    }

    public DyeColor getColor() {
        return this.dyeColor;
    }

    public class ElevatorBlockItem
    extends BlockItem {
        ElevatorBlockItem() {
            super((Block)AbstractElevator.this, new Item.Properties().func_200916_a(ElevatorModTab.TAB));
            ResourceLocation name = AbstractElevator.this.getRegistryName();
            if (name != null) {
                this.setRegistryName(name);
            }
        }
    }
}

