/*
 * Decompiled with CFR 0.152.
 */
package xyz.vsngamer.elevatorid.init;

import java.util.EnumMap;
import net.minecraft.block.Block;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import xyz.vsngamer.elevatorid.blocks.AbstractElevator;
import xyz.vsngamer.elevatorid.blocks.BlockElevator;
import xyz.vsngamer.elevatorid.blocks.DirectionalElevatorBlock;

@Mod.EventBusSubscriber(modid="elevatorid", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Registry {
    public static final EnumMap<DyeColor, AbstractElevator> ELEVATOR_BLOCKS = new EnumMap(DyeColor.class);
    private static final EnumMap<DyeColor, AbstractElevator> DIRECTIONAL_ELEVATOR_BLOCKS = new EnumMap(DyeColor.class);

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> e) {
        ELEVATOR_BLOCKS.values().forEach(block -> e.getRegistry().register((IForgeRegistryEntry)block));
        DIRECTIONAL_ELEVATOR_BLOCKS.values().forEach(block -> e.getRegistry().register((IForgeRegistryEntry)block));
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> e) {
        ELEVATOR_BLOCKS.values().forEach(block -> e.getRegistry().register((IForgeRegistryEntry)block.func_199767_j()));
        DIRECTIONAL_ELEVATOR_BLOCKS.values().forEach(block -> e.getRegistry().register((IForgeRegistryEntry)block.func_199767_j()));
    }

    static {
        for (DyeColor color : DyeColor.values()) {
            ELEVATOR_BLOCKS.put(color, new BlockElevator(color));
            DIRECTIONAL_ELEVATOR_BLOCKS.put(color, new DirectionalElevatorBlock(color));
        }
    }
}

