/*
 * Decompiled with CFR 0.152.
 */
package xyz.vsngamer.elevatorid.network;

import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.vsngamer.elevatorid.blocks.DirectionalElevatorBlock;
import xyz.vsngamer.elevatorid.init.ModConfig;
import xyz.vsngamer.elevatorid.init.ModSounds;
import xyz.vsngamer.elevatorid.init.ModTags;
import xyz.vsngamer.elevatorid.network.TeleportRequest;

public class TeleportHandler {
    static void handle(TeleportRequest message, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayerEntity player = ctx.get().getSender();
        if (player == null) {
            return;
        }
        ServerWorld world = player.func_71121_q();
        BlockPos from = message.getFrom();
        BlockPos to = message.getTo();
        double distanceSq = player.func_195048_a(new Vec3d((Vec3i)from).func_72441_c(0.0, 1.0, 0.0));
        if (distanceSq > 4.0) {
            return;
        }
        if (from.func_177958_n() != to.func_177958_n() || from.func_177952_p() != to.func_177952_p()) {
            return;
        }
        BlockState fromState = world.func_180495_p(from);
        BlockState toState = world.func_180495_p(to);
        Block toElevator = toState.func_177230_c();
        if (!TeleportHandler.isElevator(fromState) || !TeleportHandler.isElevator(toState)) {
            return;
        }
        if (!TeleportHandler.validateTarget((IBlockReader)world, to)) {
            return;
        }
        float yaw = ModTags.DIRECTIONAL_ELEVATORS_TAG.func_199685_a_((Object)toElevator) ? ((Direction)toState.func_177229_b((IProperty)DirectionalElevatorBlock.FACING)).func_185119_l() : player.field_70177_z;
        float pitch = (Boolean)ModConfig.GENERAL.resetPitchNormal.get() != false && ModTags.NORMAL_ELEVATORS_TAG.func_199685_a_((Object)toElevator) || (Boolean)ModConfig.GENERAL.resetPitchDirectional.get() != false && ModTags.DIRECTIONAL_ELEVATORS_TAG.func_199685_a_((Object)toElevator) ? 0.0f : player.field_70125_A;
        ctx.get().enqueueWork(() -> {
            if (((Boolean)ModConfig.GENERAL.precisionTarget.get()).booleanValue()) {
                player.field_71135_a.func_147364_a((double)to.func_177958_n() + 0.5, (double)to.func_177956_o() + 1.0, (double)to.func_177952_p() + 0.5, yaw, pitch);
            } else {
                player.field_71135_a.func_147364_a(player.field_70165_t, (double)to.func_177956_o() + 1.0, player.field_70161_v, yaw, pitch);
            }
            player.func_213317_d(player.func_213322_ci().func_216369_h(new Vec3d(1.0, 0.0, 1.0)));
            world.func_184133_a(null, to, ModSounds.TELEPORT, SoundCategory.BLOCKS, 1.0f, 1.0f);
        });
    }

    public static boolean validateTarget(IBlockReader world, BlockPos target) {
        return TeleportHandler.validateTarget(world.func_180495_p(target.func_177981_b(1))) && TeleportHandler.validateTarget(world.func_180495_p(target.func_177981_b(2)));
    }

    private static boolean validateTarget(BlockState blockState) {
        return !blockState.func_185904_a().func_76220_a();
    }

    public static boolean isElevator(BlockState blockState) {
        return ModTags.ALL_ELEVATORS_TAG.func_199685_a_((Object)blockState.func_177230_c());
    }
}

