/*
 * Decompiled with CFR 0.152.
 */
package xyz.vsngamer.elevator.network;

import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import xyz.vsngamer.elevator.blocks.BlockElevator;
import xyz.vsngamer.elevator.init.ModConfig;
import xyz.vsngamer.elevator.init.ModSounds;
import xyz.vsngamer.elevator.network.TeleportRequest;

public class TeleportHandler
implements IMessageHandler<TeleportRequest, IMessage> {
    public IMessage onMessage(TeleportRequest message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        World world = player.field_70170_p;
        BlockPos from = message.getFrom();
        BlockPos to = message.getTo();
        if (from.func_177958_n() != to.func_177958_n() || from.func_177952_p() != to.func_177952_p()) {
            return null;
        }
        IBlockState fromState = world.func_180495_p(from);
        IBlockState toState = world.func_180495_p(to);
        if (fromState.func_177230_c() != toState.func_177230_c() || !TeleportHandler.isElevator(fromState) || !TeleportHandler.isElevator(toState)) {
            return null;
        }
        if (player.func_174831_c(from) > 9.0) {
            return null;
        }
        if (!TeleportHandler.validateTarget((IBlockAccess)world, to)) {
            return null;
        }
        if (ModConfig.precisionTarget) {
            player.func_70634_a((double)((float)to.func_177958_n() + 0.5f), (double)(to.func_177956_o() + 1), (double)((float)to.func_177952_p() + 0.5f));
        } else {
            player.func_70634_a((double)(to.func_177958_n() - from.func_177958_n()) + player.field_70165_t, (double)(to.func_177956_o() - from.func_177956_o()) + player.field_70163_u, (double)(to.func_177952_p() - from.func_177952_p()) + player.field_70161_v);
        }
        player.field_70181_x = 0.0;
        world.func_184133_a(null, to, ModSounds.teleport, SoundCategory.BLOCKS, 1.0f, 1.0f);
        return null;
    }

    public static boolean validateTarget(IBlockAccess world, BlockPos target) {
        return TeleportHandler.validateTarget(world.func_180495_p(target.func_177981_b(1))) && TeleportHandler.validateTarget(world.func_180495_p(target.func_177981_b(2)));
    }

    private static boolean validateTarget(IBlockState blockState) {
        return blockState.func_185904_a() == Material.field_151579_a || !blockState.func_185914_p();
    }

    public static boolean isElevator(IBlockState blockState) {
        return blockState.func_177230_c() instanceof BlockElevator;
    }
}

