/*
 * Decompiled with CFR 0.152.
 */
package com.sonicjumper.enhancedvisuals.shaders.util;

import com.sonicjumper.enhancedvisuals.shaders.util.ITexture;
import com.sonicjumper.enhancedvisuals.shaders.util.PNGDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;

public class Texture
implements ITexture {
    protected int id;
    protected int width;
    protected int height;
    public static final int LINEAR = 9729;
    public static final int NEAREST = 9728;
    public static final int LINEAR_MIPMAP_LINEAR = 9987;
    public static final int LINEAR_MIPMAP_NEAREST = 9985;
    public static final int NEAREST_MIPMAP_NEAREST = 9984;
    public static final int NEAREST_MIPMAP_LINEAR = 9986;
    public static final int CLAMP = 10496;
    public static final int CLAMP_TO_EDGE = 33071;
    public static final int REPEAT = 10497;
    public static final int DEFAULT_FILTER = 9728;
    public static final int DEFAULT_WRAP = 10497;

    public static int toPowerOfTwo(int n) {
        return 1 << 32 - Integer.numberOfLeadingZeros(n - 1);
    }

    public static boolean isPowerOfTwo(int n) {
        return (n & -n) == n;
    }

    public static boolean isNPOTSupported() {
        return GLContext.getCapabilities().GL_ARB_texture_non_power_of_two;
    }

    protected Texture() {
    }

    public Texture(int width, int height) {
        this(width, height, 9728);
    }

    public Texture(int width, int height, int filter) {
        this(width, height, filter, 10497);
    }

    public Texture(int width, int height, int filter, int wrap) {
        GL11.glEnable((int)this.getTarget());
        this.id = GL11.glGenTextures();
        this.width = width;
        this.height = height;
        this.bind();
        this.setFilter(filter);
        this.setWrap(wrap);
        ByteBuffer buf = BufferUtils.createByteBuffer((int)(width * height * 4));
        this.upload(6408, buf);
    }

    public Texture(URL pngRef) throws IOException {
        this(pngRef, 9728);
    }

    public Texture(URL pngRef, int filter) throws IOException {
        this(pngRef, filter, 10497);
    }

    public Texture(URL pngRef, int filter, int wrap) throws IOException {
        this(pngRef, filter, filter, wrap, false);
    }

    public Texture(URL pngRef, int filter, boolean genMipmap) throws IOException {
        this(pngRef, filter, filter, 10497, genMipmap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Texture(URL pngRef, int minFilter, int magFilter, int wrap, boolean genMipmap) throws IOException {
        InputStream input = null;
        try {
            input = pngRef.openStream();
            PNGDecoder dec = new PNGDecoder(input);
            this.width = dec.getWidth();
            this.height = dec.getHeight();
            ByteBuffer buf = BufferUtils.createByteBuffer((int)(4 * this.width * this.height));
            dec.decode(buf, this.width * 4, PNGDecoder.Format.RGBA);
            buf.flip();
            GL11.glEnable((int)this.getTarget());
            this.id = GL11.glGenTextures();
            this.bind();
            this.setFilter(minFilter, magFilter);
            this.setWrap(wrap);
            this.upload(6408, buf);
            if (genMipmap) {
                EXTFramebufferObject.glGenerateMipmapEXT((int)this.getTarget());
            }
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public int getTarget() {
        return 3553;
    }

    public int getID() {
        return this.id;
    }

    protected void setUnpackAlignment() {
        GL11.glPixelStorei((int)3317, (int)1);
        GL11.glPixelStorei((int)3333, (int)1);
    }

    public void upload(int dataFormat, ByteBuffer data) {
        this.bind();
        this.setUnpackAlignment();
        GL11.glTexImage2D((int)this.getTarget(), (int)0, (int)6408, (int)this.width, (int)this.height, (int)0, (int)dataFormat, (int)5121, (ByteBuffer)data);
    }

    public void upload(int x, int y, int width, int height, int dataFormat, ByteBuffer data) {
        this.bind();
        this.setUnpackAlignment();
        GL11.glTexSubImage2D((int)this.getTarget(), (int)0, (int)x, (int)y, (int)width, (int)height, (int)dataFormat, (int)5121, (ByteBuffer)data);
    }

    public void setFilter(int filter) {
        this.setFilter(filter, filter);
    }

    public void setFilter(int minFilter, int magFilter) {
        this.bind();
        GL11.glTexParameteri((int)this.getTarget(), (int)10241, (int)minFilter);
        GL11.glTexParameteri((int)this.getTarget(), (int)10240, (int)magFilter);
    }

    public void setWrap(int wrap) {
        this.bind();
        GL11.glTexParameteri((int)this.getTarget(), (int)10242, (int)wrap);
        GL11.glTexParameteri((int)this.getTarget(), (int)10243, (int)wrap);
    }

    public void bind() {
        if (!this.valid()) {
            throw new IllegalStateException("trying to bind a texture that was disposed");
        }
        GL11.glBindTexture((int)this.getTarget(), (int)this.id);
    }

    public void dispose() {
        if (this.valid()) {
            GL11.glDeleteTextures((int)this.id);
            this.id = 0;
        }
    }

    public boolean valid() {
        return this.id != 0;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public Texture getTexture() {
        return this;
    }

    @Override
    public float getU() {
        return 0.0f;
    }

    @Override
    public float getV() {
        return 0.0f;
    }

    @Override
    public float getU2() {
        return 1.0f;
    }

    @Override
    public float getV2() {
        return 1.0f;
    }
}

