/*
 * Decompiled with CFR 0.152.
 */
package com.sonicjumper.enhancedvisuals.visuals;

import com.sonicjumper.enhancedvisuals.filters.AbstractBufferedImageOp;
import com.sonicjumper.enhancedvisuals.render.BlurHelper;
import com.sonicjumper.enhancedvisuals.render.RenderBlur;
import com.sonicjumper.enhancedvisuals.render.RenderVisual;
import com.sonicjumper.enhancedvisuals.visuals.Visual;
import com.sonicjumper.enhancedvisuals.visuals.VisualType;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import net.minecraft.client.Minecraft;
import org.lwjgl.BufferUtils;

public class Blur
extends Visual {
    protected ByteBuffer image;
    protected int imageHeight;
    protected int imageWidth;
    protected boolean resetsOnTick;
    protected float blurScaling;
    public AbstractBufferedImageOp filter;

    public Blur(VisualType type, int time, Color rgba, boolean resets, float scale) {
        super(type, time, rgba);
        this.resetsOnTick = resets;
        this.blurScaling = scale;
    }

    public void resetBufferedImage(float translucency) {
        if (this.resetsOnTick || this.image == null) {
            BufferedImage screen = BlurHelper.captureScreenAsImage(Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
            if (this.filter != null) {
                BufferedImage scaledImage = BlurHelper.scaleImage(screen, this.blurScaling);
                this.image = this.prepareImage(this.filter.filter(scaledImage, null));
            } else {
                this.image = this.prepareImage(screen);
            }
        }
    }

    protected ByteBuffer prepareImage(BufferedImage image) {
        this.imageHeight = image.getHeight();
        this.imageWidth = image.getWidth();
        int[] pixels = new int[image.getWidth() * image.getHeight()];
        this.filter.getRGB(image, 0, 0, this.imageWidth, this.imageHeight, pixels);
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)(this.imageWidth * this.imageHeight * 3));
        for (int y = 0; y < this.imageHeight; ++y) {
            for (int x = 0; x < this.imageWidth; ++x) {
                int pixel = pixels[y * this.imageWidth + x];
                buffer.put((byte)(pixel >> 16 & 0xFF));
                buffer.put((byte)(pixel >> 8 & 0xFF));
                buffer.put((byte)(pixel & 0xFF));
            }
        }
        buffer.flip();
        return buffer;
    }

    @Override
    public void tickUpdate() {
        super.tickUpdate();
    }

    @Override
    public void renderUpdate(float partialTicks) {
        if (this.filter == null) {
            this.filter = this.getFilter();
        }
        this.resetBufferedImage(this.getTranslucencyByTime());
        super.renderUpdate(partialTicks);
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    @Override
    public RenderVisual getRenderer() {
        return new RenderBlur();
    }

    public ByteBuffer getBufferedImage() {
        return this.image;
    }

    public AbstractBufferedImageOp getFilter() {
        return null;
    }

    public float getScale() {
        return this.blurScaling;
    }
}

