/*
 * Decompiled with CFR 0.152.
 */
package com.sonicjumper.enhancedvisuals.event;

import com.sonicjumper.enhancedvisuals.Base;
import com.sonicjumper.enhancedvisuals.render.RenderVisual;
import com.sonicjumper.enhancedvisuals.visuals.Visual;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class VisualRenderer {
    private HashMap<Class, RenderVisual> rendererMapStore = new HashMap();

    @SubscribeEvent
    public void onRenderTick(RenderGameOverlayEvent event) {
        if (event.type != RenderGameOverlayEvent.ElementType.HOTBAR || event.isCancelable()) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.renderStuff(event.renderTickTime);
        }
    }

    private void renderStuff(float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!mc.func_147113_T()) {
            ArrayList<Visual> visualList;
            if (Base.instance != null && Base.instance.shaderHelper != null && Base.instance.shaderHelper.getShaderGroup() != null && Base.instance.shaderHelper.getShaderGroup().needNewFrameBuffer(mc.field_71443_c, mc.field_71440_d)) {
                Base.instance.shaderHelper.getShaderGroup().createBindFramebuffers(mc.field_71443_c, mc.field_71440_d);
            }
            if ((visualList = Base.instance.manager.getActiveVisuals()).size() > 0) {
                this.setupOverlayRendering();
                GlStateManager.func_179147_l();
                GlStateManager.func_179097_i();
                GlStateManager.func_179132_a((boolean)false);
                GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179118_c();
                try {
                    for (int i = 0; i < visualList.size(); ++i) {
                        Visual v = visualList.get(i);
                        v.getRenderer().renderVisual(v, partialTicks);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                Base.instance.shaderHelper.drawShaders(partialTicks);
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179126_j();
                GlStateManager.func_179141_d();
                GlStateManager.func_179140_f();
            }
        }
    }

    public void setupOverlayRendering() {
        ScaledResolution scaledresolution = new ScaledResolution(Minecraft.func_71410_x());
        GlStateManager.func_179086_m((int)256);
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179096_D();
        GlStateManager.func_179130_a((double)0.0, (double)scaledresolution.func_78327_c(), (double)scaledresolution.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179096_D();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2000.0f);
    }

    public RenderVisual getRendererForClass(Class<? extends RenderVisual> clazz) {
        if (!this.rendererMapStore.containsKey(clazz)) {
            try {
                this.rendererMapStore.put(clazz, clazz.newInstance());
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return this.rendererMapStore.get(clazz);
    }
}

