/*
 * Decompiled with CFR 0.152.
 */
package com.sonicjumper.enhancedvisuals.shaders.util;

import org.lwjgl.util.vector.Matrix4f;

public class MathUtil {
    public static Matrix4f toOrtho2D(Matrix4f m, float x, float y, float width, float height) {
        return MathUtil.toOrtho(m, x, x + width, y + height, y, 1.0f, -1.0f);
    }

    public static Matrix4f toOrtho2D(Matrix4f m, float x, float y, float width, float height, float near, float far) {
        return MathUtil.toOrtho(m, x, x + width, y, y + height, near, far);
    }

    public static Matrix4f toOrtho(Matrix4f m, float left, float right, float bottom, float top, float near, float far) {
        if (m == null) {
            m = new Matrix4f();
        }
        float x_orth = 2.0f / (right - left);
        float y_orth = 2.0f / (top - bottom);
        float z_orth = -2.0f / (far - near);
        float tx = -(right + left) / (right - left);
        float ty = -(top + bottom) / (top - bottom);
        float tz = -(far + near) / (far - near);
        m.m00 = x_orth;
        m.m10 = 0.0f;
        m.m20 = 0.0f;
        m.m30 = 0.0f;
        m.m01 = 0.0f;
        m.m11 = y_orth;
        m.m21 = 0.0f;
        m.m31 = 0.0f;
        m.m02 = 0.0f;
        m.m12 = 0.0f;
        m.m22 = z_orth;
        m.m32 = 0.0f;
        m.m03 = tx;
        m.m13 = ty;
        m.m23 = tz;
        m.m33 = 1.0f;
        return m;
    }

    public static Matrix4f setToProjection(Matrix4f m, float near, float far, float fov, float aspectRatio) {
        if (m == null) {
            m = new Matrix4f();
        }
        m.setIdentity();
        float l_fd = (float)(1.0 / Math.tan((double)fov * (Math.PI / 180) / 2.0));
        float l_a1 = (far + near) / (near - far);
        float l_a2 = 2.0f * far * near / (near - far);
        m.m00 = l_fd / aspectRatio;
        m.m10 = 0.0f;
        m.m20 = 0.0f;
        m.m30 = 0.0f;
        m.m01 = 0.0f;
        m.m11 = l_fd;
        m.m21 = 0.0f;
        m.m31 = 0.0f;
        m.m02 = 0.0f;
        m.m12 = 0.0f;
        m.m22 = l_a1;
        m.m32 = -1.0f;
        m.m03 = 0.0f;
        m.m13 = 0.0f;
        m.m23 = l_a2;
        m.m33 = 0.0f;
        return m;
    }
}

