/*
 * Decompiled with CFR 0.152.
 */
package com.sonicjumper.enhancedvisuals.shaders.util;

import com.sonicjumper.enhancedvisuals.shaders.util.VertexAttrib;
import com.sonicjumper.enhancedvisuals.shaders.util.VertexData;
import java.nio.FloatBuffer;
import java.util.List;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

public class VertexArray
implements VertexData {
    protected VertexAttrib[] attributes;
    private int totalNumComponents;
    private int stride;
    private FloatBuffer buffer;
    private int vertCount;

    public VertexArray(int vertCount, VertexAttrib ... attributes) {
        this.attributes = attributes;
        for (VertexAttrib a : attributes) {
            this.totalNumComponents += a.numComponents;
        }
        this.vertCount = vertCount;
        this.buffer = BufferUtils.createFloatBuffer((int)(vertCount * this.totalNumComponents));
    }

    public VertexArray(int vertCount, List<VertexAttrib> attributes) {
        this(vertCount, attributes.toArray(new VertexAttrib[attributes.size()]));
    }

    @Override
    public VertexArray flip() {
        this.buffer.flip();
        return this;
    }

    @Override
    public VertexArray clear() {
        this.buffer.clear();
        return this;
    }

    @Override
    public VertexArray put(float[] verts, int offset, int length) {
        this.buffer.put(verts, offset, length);
        return this;
    }

    @Override
    public VertexArray put(float f) {
        this.buffer.put(f);
        return this;
    }

    @Override
    public FloatBuffer buffer() {
        return this.buffer;
    }

    @Override
    public int getTotalNumComponents() {
        return this.totalNumComponents;
    }

    @Override
    public int getVertexCount() {
        return this.vertCount;
    }

    @Override
    public void bind() {
        int offset = 0;
        int stride = this.totalNumComponents * 4;
        for (int i = 0; i < this.attributes.length; ++i) {
            VertexAttrib a = this.attributes[i];
            this.buffer.position(offset);
            GL20.glEnableVertexAttribArray((int)a.location);
            GL20.glVertexAttribPointer((int)a.location, (int)a.numComponents, (boolean)false, (int)stride, (FloatBuffer)this.buffer);
            offset += a.numComponents;
        }
    }

    @Override
    public void draw(int geom, int first, int count) {
        GL11.glDrawArrays((int)geom, (int)first, (int)count);
    }

    @Override
    public void unbind() {
        for (int i = 0; i < this.attributes.length; ++i) {
            VertexAttrib a = this.attributes[i];
            GL20.glDisableVertexAttribArray((int)a.location);
        }
    }
}

