/*
 * Decompiled with CFR 0.152.
 */
package com.sonicjumper.enhancedvisuals.visuals;

import com.sonicjumper.enhancedvisuals.Base;
import com.sonicjumper.enhancedvisuals.render.RenderVisual;
import com.sonicjumper.enhancedvisuals.visuals.VisualType;
import java.awt.Color;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.ResourceLocation;

public class Visual {
    public static Random rand = new Random();
    private VisualType visualType;
    private float xOffset;
    private float yOffset;
    private int resourceID;
    private int height;
    private int width;
    private int ticksToLive;
    private int maxTime;
    private float rotation;
    private Color color;
    private boolean isDead;
    private int realTickTime;

    public Visual(VisualType type, int lifeTime) {
        this(type, lifeTime, Color.WHITE);
    }

    public Visual(VisualType type, int lifeTime, Color rgba) {
        this.visualType = type;
        if (type.resourceArray.length > 0) {
            this.resourceID = rand.nextInt(type.resourceArray.length);
        }
        this.ticksToLive = lifeTime;
        this.maxTime = lifeTime;
        this.realTickTime = 0;
        this.width = (int)((double)type.getSize() * Math.random());
        this.height = (int)((double)type.getSize() * Math.random());
        this.rotation = (float)(Math.random() * 360.0);
        this.color = rgba;
        if (type.getCatagory().equals((Object)VisualCatagory.Splat)) {
            ScaledResolution scaledRes = new ScaledResolution(Minecraft.func_71410_x());
            this.xOffset = this.generateOffset(scaledRes.func_78326_a(), this.width);
            this.yOffset = this.generateOffset(scaledRes.func_78328_b(), this.height);
        } else {
            this.xOffset = 0.0f;
            this.yOffset = 0.0f;
        }
    }

    public Visual(VisualType type, int lifeTime, Color rgba, float xOffset, float yOffset) {
        this(type, lifeTime, rgba);
        ScaledResolution scaledRes = new ScaledResolution(Minecraft.func_71410_x());
        this.xOffset = xOffset * (float)scaledRes.func_78326_a() - (float)this.width / 2.0f;
        this.yOffset = yOffset * (float)scaledRes.func_78328_b() - (float)this.height / 2.0f;
    }

    public void beingRemoved() {
    }

    private float generateOffset(int dimensionLength, int spacingBuffer) {
        float halfDimLength = (float)dimensionLength / 2.0f;
        float multiplier = (float)(1.0 - Math.pow(rand.nextDouble(), 2.0));
        float textureCenterPosition = rand.nextInt(2) == 0 ? halfDimLength + halfDimLength * multiplier : halfDimLength - halfDimLength * multiplier;
        float textureShiftedPosition = textureCenterPosition - (float)spacingBuffer / 2.0f;
        return textureShiftedPosition;
    }

    public void renderUpdate(float partialTicks) {
        if (!this.isDead) {
            this.getRenderer().renderVisual(this, partialTicks);
        }
    }

    public void tickUpdate() {
        ++this.realTickTime;
        if (this.ticksToLive == 0) {
            this.isDead = true;
        } else if (!this.isDead) {
            int n = this.ticksToLive = this.ticksToLive < 0 ? this.ticksToLive : this.ticksToLive - 1;
        }
        if (this.shouldRemove()) {
            Base.instance.manager.removeVisual(this);
        }
    }

    public void subtractTicks(int i) {
        this.ticksToLive -= i;
        if (this.ticksToLive < 0) {
            this.ticksToLive = 0;
        }
    }

    public void subtractTickPercent(float f) {
        this.ticksToLive = (int)((float)this.ticksToLive - (float)this.maxTime * (f / 100.0f));
        if (this.ticksToLive < 0) {
            this.ticksToLive = 0;
        }
    }

    public void setTranslucency(float intensity) {
        this.color = new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), (int)(intensity * 255.0f));
    }

    public float getTranslucencyByTime() {
        if (this.ticksToLive != -1) {
            Float var1 = new Float(this.ticksToLive);
            Float var2 = new Float(this.maxTime);
            float var3 = var1.floatValue() / var2.floatValue();
            return (float)this.color.getAlpha() / 255.0f * var3;
        }
        return (float)this.color.getAlpha() / 255.0f;
    }

    public VisualType getType() {
        return this.visualType;
    }

    public int getResourceID() {
        return this.resourceID;
    }

    public float getXOffset() {
        return this.xOffset;
    }

    public float getYOffset() {
        return this.yOffset;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public Color getColor() {
        return this.color;
    }

    public int getMaxTime() {
        return this.maxTime;
    }

    public float getRotation() {
        return this.rotation;
    }

    public int getRealTickTime() {
        return this.realTickTime;
    }

    public boolean shouldRemove() {
        return this.isDead;
    }

    public ResourceLocation getResource() {
        return this.visualType.resourceArray[this.resourceID];
    }

    public RenderVisual getRenderer() {
        return Base.instance.renderer.getRendererForClass(RenderVisual.class);
    }

    public String toString() {
        return super.toString() + "[x = " + this.getXOffset() + ", y = " + this.getYOffset() + ", translucency = " + this.getTranslucencyByTime() + ", timeLeft = " + this.ticksToLive + ", maxTime = " + this.maxTime + ", resourceLocation = " + this.getResource() + "]";
    }

    public static enum VisualCatagory {
        Splat,
        Overlay,
        Animation,
        Shader;

    }
}

