/*
 * Decompiled with CFR 0.152.
 */
package com.sonicjumper.enhancedvisuals;

import com.sonicjumper.enhancedvisuals.death.DeathMessages;
import com.sonicjumper.enhancedvisuals.visuals.VisualType;
import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class ConfigCore {
    private Configuration config;
    public static String defaultThemePack = "defaulttheme";
    public static float waterSubstractFactor = 2.5f;
    public static int maxHearts = 6;
    public static float minHeartBeatLength = 15.0f;
    public static float heartBeatHeartFactor = 10.0f;
    public static int maxExplosionTime = 1000;
    public static float explosionTimeModifier = 20.0f;
    public static float minExplosionVolume = 0.0f;
    public static float explosionVolumeModifier = 10.0f;
    public static float maxBeepVolume = 0.5f;
    public static float maxBlur = 100.0f;
    public static float blurTimeFactor = 2.5f;
    public static boolean hitEffect = false;

    public ConfigCore(File configFile) {
        this.config = new Configuration(configFile);
    }

    public void loadConfig() {
        this.config.load();
        waterSubstractFactor = this.config.getFloat("waterSubstractFactor", "general", 2.5f, 0.0f, 100000.0f, "increased fade out factor in water");
        maxHearts = this.config.getInt("heartLevel", "heartbeat", 6, 0, 20, "below or equal means hearbeat take effect");
        minHeartBeatLength = this.config.getFloat("minHeartBeatLength", "heartbeat", 10.0f, 0.0f, 100000.0f, "time between heartbeats = player.health * heartBeatHeartFactor + minHeartBeatLength");
        heartBeatHeartFactor = this.config.getFloat("heartBeatHeartFactor", "heartbeat", 10.0f, 0.0f, 100000.0f, "time between heartbeats = player.health * heartBeatHeartFactor + minHeartBeatLength");
        maxExplosionTime = this.config.getInt("maxExplosionTime", "explosion", maxExplosionTime, 0, 100000, "maximum explosion duration");
        explosionTimeModifier = this.config.getFloat("explosionTimeModifier", "explosion", explosionTimeModifier, 0.0f, 100000.0f, "time = Math.max(maxExplosionTime, damage*explosionTimeModifier)");
        minExplosionVolume = this.config.getFloat("minExplosionVolume", "explosion", minExplosionVolume, 0.0f, 100000.0f, "factor of all other sounsd (muting effect)");
        explosionVolumeModifier = this.config.getFloat("explosionVolumeModifier", "explosion", explosionVolumeModifier, 0.0f, 100000.0f, "volume of beep = damage/ConfigCore.explosionVolumeModifier");
        maxBeepVolume = this.config.getFloat("maxBeepVolume", "explosion", maxBeepVolume, 0.0f, 100000.0f, "max volume of a beep");
        maxBlur = this.config.getFloat("maxBlur", "explosion", maxBlur, 0.0f, 100000.0f, "max blur effect");
        blurTimeFactor = this.config.getFloat("blurTimeFactor", "explosion", blurTimeFactor, 0.0f, 100000.0f, "time of blur = time of muted sounds / blurTimeFactor");
        hitEffect = this.config.getBoolean("hitEffect", "hit", false, "Red overlay effect once you get hit");
        for (int i = 0; i < VisualType.visuals.size(); ++i) {
            VisualType.visuals.get(i).loadConfig(this.config);
        }
        DeathMessages.loadConfig(this.config);
        this.config.save();
    }
}

