/*
 * Decompiled with CFR 0.152.
 */
package com.sonicjumper.enhancedvisuals.event;

import com.sonicjumper.enhancedvisuals.Base;
import com.sonicjumper.enhancedvisuals.ConfigCore;
import com.sonicjumper.enhancedvisuals.environment.BaseEnvironmentEffect;
import com.sonicjumper.enhancedvisuals.environment.PotionSplashHandler;
import com.sonicjumper.enhancedvisuals.event.SoundMuteHandler;
import com.sonicjumper.enhancedvisuals.render.RenderShaderBlurFade;
import com.sonicjumper.enhancedvisuals.visuals.ShaderBlurFade;
import com.sonicjumper.enhancedvisuals.visuals.ShaderDesaturate;
import com.sonicjumper.enhancedvisuals.visuals.Visual;
import com.sonicjumper.enhancedvisuals.visuals.VisualType;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiGameOver;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.event.sound.SoundEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class VisualEventHandler {
    private ArrayList<BaseEnvironmentEffect> environmentalEffects;
    public PotionSplashHandler potionSplashHandler = new PotionSplashHandler(this);
    public Minecraft mc = Minecraft.func_71410_x();
    private ArrayList<Item> sharpList = new ArrayList();
    private ArrayList<Item> bluntList = new ArrayList();
    private ArrayList<Item> pierceList = new ArrayList();
    private Random rand;
    private int lowHealthBuffer;

    public VisualEventHandler() {
        this.sharpList.add(Items.field_151040_l);
        this.sharpList.add(Items.field_151041_m);
        this.sharpList.add(Items.field_151052_q);
        this.sharpList.add(Items.field_151048_u);
        this.sharpList.add(Items.field_151010_B);
        this.sharpList.add(Items.field_151036_c);
        this.sharpList.add(Items.field_151053_p);
        this.sharpList.add(Items.field_151049_t);
        this.sharpList.add(Items.field_151056_x);
        this.sharpList.add(Items.field_151006_E);
        this.bluntList.add(Items.field_151035_b);
        this.bluntList.add(Items.field_151039_o);
        this.bluntList.add(Items.field_151050_s);
        this.bluntList.add(Items.field_151046_w);
        this.bluntList.add(Items.field_151005_D);
        this.bluntList.add(Items.field_151037_a);
        this.bluntList.add(Items.field_151038_n);
        this.bluntList.add(Items.field_151051_r);
        this.bluntList.add(Items.field_151047_v);
        this.bluntList.add(Items.field_151011_C);
        this.pierceList.add(Items.field_151019_K);
        this.pierceList.add(Items.field_151017_I);
        this.pierceList.add(Items.field_151018_J);
        this.pierceList.add(Items.field_151012_L);
        this.pierceList.add(Items.field_151013_M);
        this.pierceList.add(Items.field_151032_g);
        this.rand = new Random();
        this.environmentalEffects = new ArrayList();
        this.environmentalEffects.add(this.potionSplashHandler);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onPlayerDamage(LivingAttackEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            this.entityDamaged(event.getEntityLiving(), event.getSource(), event.getAmount());
        }
    }

    @SubscribeEvent
    public void playerTickEvent(TickEvent.PlayerTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.END) && !(Minecraft.func_71410_x().field_71462_r instanceof GuiGameOver)) {
            this.onTickInGame(Minecraft.func_71410_x().field_71439_g != null);
        }
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent e) {
        if (e.getEntityLiving().equals((Object)this.mc.field_71439_g)) {
            Base.instance.manager.clearAllVisuals();
        }
    }

    private void entityDamaged(EntityLivingBase entity, DamageSource source, float damage) {
        if (source == DamageSource.field_76380_i || damage == 0.0f) {
            return;
        }
        double distanceSq = Minecraft.func_71410_x().field_71439_g.func_70068_e((Entity)entity);
        if (distanceSq > 64.0) {
            return;
        }
        if (entity instanceof EntityPlayer) {
            Entity attacker;
            if (ConfigCore.hitEffect) {
                Base.instance.manager.addVisualsWithShading(VisualType.lowhealth, 1, 15, 20, new Color(1.0f, 1.0f, 1.0f, 0.2f));
            }
            if ((attacker = source.func_76364_f()) instanceof EntityArrow) {
                Base.instance.manager.createVisualFromDamage(VisualType.pierce, damage, entity);
            }
            if (attacker instanceof EntityLivingBase) {
                EntityLivingBase lastAttacker = (EntityLivingBase)attacker;
                if (lastAttacker.func_184614_ca() != null) {
                    if (this.isSharp(lastAttacker.func_184614_ca().func_77973_b())) {
                        Base.instance.manager.createVisualFromDamageAndDistance(VisualType.slash, damage, entity, distanceSq);
                    } else if (this.isBlunt(lastAttacker.func_184614_ca().func_77973_b())) {
                        Base.instance.manager.createVisualFromDamageAndDistance(VisualType.impact, damage, entity, distanceSq);
                    } else if (this.isPierce(lastAttacker.func_184614_ca().func_77973_b())) {
                        Base.instance.manager.createVisualFromDamageAndDistance(VisualType.pierce, damage, entity, distanceSq);
                    } else {
                        Base.instance.manager.createVisualFromDamageAndDistance(VisualType.splatter, damage, entity, distanceSq);
                    }
                } else if (lastAttacker instanceof EntityZombie || lastAttacker instanceof EntitySkeleton || lastAttacker instanceof EntityOcelot) {
                    Base.instance.manager.createVisualFromDamageAndDistance(VisualType.slash, damage, entity, distanceSq);
                } else if (lastAttacker instanceof EntityGolem || lastAttacker instanceof EntityPlayer) {
                    Base.instance.manager.createVisualFromDamageAndDistance(VisualType.impact, damage, entity, distanceSq);
                } else if (lastAttacker instanceof EntityWolf || lastAttacker instanceof EntitySpider) {
                    Base.instance.manager.createVisualFromDamageAndDistance(VisualType.pierce, damage, entity, distanceSq);
                }
            }
            if (source == DamageSource.field_76367_g) {
                Base.instance.manager.createVisualFromDamage(VisualType.pierce, damage, entity);
            }
            if (source == DamageSource.field_76379_h || source == DamageSource.field_82729_p) {
                Base.instance.manager.createVisualFromDamage(VisualType.impact, damage, entity);
            }
            if (source.func_94541_c()) {
                Base.instance.manager.addVisuals(VisualType.dust, (int)Math.min(40.0f, damage * VisualType.dust.multiplier), VisualType.dust.minDuration, VisualType.dust.maxDuration);
                float volume = Math.max(ConfigCore.minExplosionVolume, 1.0f - damage / ConfigCore.explosionVolumeModifier);
                int time = (int)Math.min((float)ConfigCore.maxExplosionTime, damage * ConfigCore.explosionTimeModifier);
                if (!SoundMuteHandler.isMuting) {
                    this.playSound(new ResourceLocation("enhancedvisuals:ringing"), null, (1.0f - volume) * ConfigCore.maxBeepVolume);
                }
                SoundMuteHandler.startMuting(time, volume);
                Base.instance.manager.addVisualDirect(new ShaderBlurFade((VisualType)VisualType.blur, (int)((float)time / ConfigCore.blurTimeFactor), ConfigCore.maxBlur));
            }
            if (source.equals(DamageSource.field_76369_e)) {
                Base.instance.manager.addRandomNumVisualsWithColor(VisualType.waterS, VisualType.waterS.minSplashes, VisualType.waterS.maxSplashes, VisualType.waterS.minDuration, VisualType.waterS.maxDuration, new Color(1.0f, 1.0f, 1.0f, 1.0f));
            }
            if (source.func_76347_k() || source == DamageSource.field_76370_b) {
                Base.instance.manager.addVisualsWithShading(VisualType.fire, VisualType.fire.splashes, VisualType.fire.minDuration, VisualType.fire.maxDuration, new Color(1, 1, 1));
            }
        } else if ((source == DamageSource.field_82728_o || source == DamageSource.field_76379_h || source == DamageSource.field_82729_p || source.func_76355_l().equals("mob") || source.func_76355_l().equals("player")) && (double)source.func_76346_g().func_70032_d((Entity)this.mc.field_71439_g) < 8.0) {
            Base.instance.manager.createVisualFromDamageAndDistance(VisualType.splatter, damage, entity, distanceSq);
        }
    }

    public synchronized void onTickInGame(boolean isInGame) {
        Object s;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        boolean hasBlurShader = false;
        ArrayList<Visual> vList = Base.instance.manager.getActiveVisuals();
        for (int i = 0; i < vList.size(); ++i) {
            Visual v = vList.get(i);
            if (v instanceof ShaderBlurFade) {
                hasBlurShader = true;
            }
            if (v == null) continue;
            v.tickUpdate();
        }
        if (!hasBlurShader && RenderShaderBlurFade.lastBlurRadius != 0.0f) {
            RenderShaderBlurFade.resetBlur();
        }
        float aimedSaturation = VisualType.desaturate.defaultSaturation;
        if (isInGame && player.func_71024_bL().func_75116_a() <= VisualType.desaturate.maxFoodLevelEffected) {
            float leftFoodInSpan = player.func_71024_bL().func_75116_a() - VisualType.desaturate.minFoodLevelEffected;
            float spanLength = VisualType.desaturate.maxFoodLevelEffected - VisualType.desaturate.minFoodLevelEffected;
            aimedSaturation = Math.max(VisualType.desaturate.minSaturation, leftFoodInSpan / spanLength * VisualType.desaturate.defaultSaturation);
        }
        if (ShaderDesaturate.Saturation < aimedSaturation) {
            ShaderDesaturate.Saturation = Math.min(ShaderDesaturate.Saturation + VisualType.desaturate.fadeFactor, aimedSaturation);
        } else if (ShaderDesaturate.Saturation > aimedSaturation) {
            ShaderDesaturate.Saturation = Math.max(ShaderDesaturate.Saturation - VisualType.desaturate.fadeFactor, aimedSaturation);
        }
        if (!isInGame) {
            return;
        }
        for (BaseEnvironmentEffect ee : this.environmentalEffects) {
            ee.onTick();
        }
        if (this.hasSplashed((EntityPlayer)player)) {
            s = new ShaderBlurFade((VisualType)VisualType.blur, (int)(VisualType.blur.splashMinDuration + this.rand.nextFloat() * VisualType.blur.splashAdditionalDuration), VisualType.blur.splashMinIntensity + this.rand.nextFloat() * VisualType.blur.splashAdditionalIntensity);
            Base.instance.manager.addVisualDirect((Visual)s);
        }
        if (player.func_70090_H()) {
            for (Visual v : Base.instance.manager.getActiveVisuals()) {
                if (!v.getType().substractByTime) continue;
                v.subtractTickPercent(ConfigCore.waterSubstractFactor);
            }
        }
        if (player.func_110143_aJ() <= (float)ConfigCore.maxHearts) {
            if (this.lowHealthBuffer <= 0) {
                float f1 = (7.0f - player.func_110143_aJ()) * 0.2f;
                this.lowHealthBuffer = (int)(player.func_110143_aJ() * ConfigCore.heartBeatHeartFactor + ConfigCore.minHeartBeatLength);
                Base.instance.manager.addVisualsWithShading(VisualType.lowhealth, 1, this.lowHealthBuffer - 5, this.lowHealthBuffer - 5, new Color(1.0f, 1.0f, 1.0f, Math.min(0.7f, f1)));
                ShaderBlurFade s2 = new ShaderBlurFade((VisualType)VisualType.blur, (int)VisualType.blur.heartBeatDuration, Math.min(0.7f, f1) * VisualType.blur.heartBeatIntensity);
                Base.instance.manager.addVisualDirect(s2);
                this.playSound(new ResourceLocation("enhancedvisuals:heartbeatOut"), new BlockPos((Entity)player));
            } else if (this.lowHealthBuffer == 5) {
                this.playSound(new ResourceLocation("enhancedvisuals:heartbeatIn"), new BlockPos((Entity)player));
                s = new ShaderBlurFade((VisualType)VisualType.blur, (int)VisualType.blur.heartBeatDuration, VisualType.blur.heartBeatIntensity);
                Base.instance.manager.addVisualDirect((Visual)s);
                --this.lowHealthBuffer;
            } else {
                --this.lowHealthBuffer;
            }
        }
        this.checkRecentPotions();
        this.checkSlender();
        this.addSandSplatFromTick();
        SoundMuteHandler.tick();
    }

    public synchronized void playSound(ResourceLocation location, BlockPos pos) {
        this.playSound(location, pos, 1.0f);
    }

    public synchronized void playSound(ResourceLocation location, BlockPos pos, float volume) {
        if (pos != null) {
            this.mc.func_147118_V().func_147681_a((ISound)new PositionedSoundRecord(new SoundEvent(location), SoundCategory.MASTER, volume, 1.0f, pos), 0);
        } else {
            this.mc.func_147118_V().func_147681_a((ISound)new PositionedSoundRecord(location, SoundCategory.MASTER, volume, 1.0f, false, 0, ISound.AttenuationType.NONE, 0.0f, 0.0f, 0.0f), 0);
        }
    }

    public void addSandSplatFromTick() {
        if (this.mc.field_71439_g.field_70122_E && this.isOnSand((EntityPlayer)this.mc.field_71439_g)) {
            float modifier = VisualType.sand.defaultmodifier;
            if (this.mc.field_71439_g.func_70051_ag()) {
                modifier = VisualType.sand.sprintingmodifier;
            }
            Base.instance.manager.addVisuals(VisualType.sand, (int)(Math.random() * (double)modifier), VisualType.sand.minDuration, VisualType.sand.maxDuration);
        }
    }

    private boolean isOnSand(EntityPlayer entityPlayer) {
        int posX = (int)entityPlayer.field_70165_t;
        int posY = (int)(entityPlayer.field_70163_u - 2.0);
        int posZ = (int)entityPlayer.field_70161_v;
        return this.mc.field_71441_e.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() == Blocks.field_150354_m && this.mc.field_71441_e.func_180495_p(new BlockPos(posX, posY + 1, posZ)).func_177230_c() == Blocks.field_150354_m;
    }

    private void checkSlender() {
        boolean angryNearby = false;
        float modifier = 0.0f;
        double d0 = this.mc.field_71439_g.field_70165_t;
        double d1 = this.mc.field_71439_g.field_70163_u;
        double d2 = this.mc.field_71439_g.field_70161_v;
        AxisAlignedBB box = this.mc.field_71439_g.func_174813_aQ();
        EntityEnderman mob = (EntityEnderman)this.mc.field_71441_e.func_72857_a(EntityEnderman.class, box = box.func_72314_b(16.0, 16.0, 16.0), (Entity)this.mc.field_71439_g);
        if (mob != null) {
            angryNearby = true;
            float distModifier = (float)(1.0 / Math.pow(Math.sqrt(Math.pow(d0 - mob.field_70165_t, 2.0) + Math.pow(d1 - mob.field_70163_u, 2.0) + Math.pow(d2 - mob.field_70161_v, 2.0)) / 3.0, 2.0));
            if (distModifier > modifier && (modifier = distModifier) > 3.5f) {
                modifier = 3.5f;
            }
        }
        Base.instance.manager.slenderOverlay.intensity = angryNearby ? Math.max(VisualType.slender.defaultIntensity, Math.min(VisualType.slender.maxIntensity, VisualType.slender.slenderDistanceFactor * modifier)) : VisualType.slender.defaultIntensity;
    }

    private void checkRecentPotions() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        AxisAlignedBB axisBox = new AxisAlignedBB(Math.floor(player.field_70165_t) - 4.5, Math.floor(player.field_70163_u) - 5.0, Math.floor(player.field_70161_v) - 4.5, Math.floor(player.field_70165_t) + 4.5, Math.floor(player.field_70163_u) + 2.0, Math.floor(player.field_70161_v) + 4.5);
        for (EntityPotion entityPotion : (ArrayList)Minecraft.func_71410_x().field_71441_e.func_72872_a(EntityPotion.class, axisBox)) {
            if (!entityPotion.field_70128_L) continue;
            double distance = Math.sqrt(Math.pow(Math.floor(player.field_70165_t) - entityPotion.field_70165_t, 2.0) + Math.pow(Math.floor(player.field_70163_u + (double)player.eyeHeight) - entityPotion.field_70163_u, 2.0) + Math.pow(Math.floor(player.field_70161_v) - entityPotion.field_70161_v, 2.0));
            double modifier = 1.0 / distance;
            int bitColor = PotionUtils.func_185183_a((PotionType)PotionUtils.func_185191_c((ItemStack)entityPotion.func_184543_l()));
            float r = (float)(bitColor >> 16 & 0xFF) / 255.0f;
            float g = (float)(bitColor >> 8 & 0xFF) / 255.0f;
            float b = (float)(bitColor & 0xFF) / 255.0f;
            float f1 = (float)(modifier * 2.0);
            Base.instance.manager.addVisualsWithShading(VisualType.potion, 1, 30, 60, new Color(r, g, b, f1 <= 1.0f ? f1 : 1.0f));
        }
    }

    @SubscribeEvent
    public void onSoundPlayed(SoundEvent.SoundSourceEvent event) {
        if (SoundMuteHandler.isMuting && SoundMuteHandler.ignoredSounds != null && event.getSound().func_147650_b().toString().equals("enhancedvisuals:ringing")) {
            SoundMuteHandler.ignoredSounds.add(event.getUuid());
        }
    }

    private boolean isSharp(Item item) {
        return this.sharpList.contains(item);
    }

    private boolean isBlunt(Item item) {
        return this.bluntList.contains(item);
    }

    private boolean isPierce(Item item) {
        return this.pierceList.contains(item);
    }

    private boolean hasSplashed(EntityPlayer entityPlayer) {
        int x = (int)Math.floor(entityPlayer.field_70165_t);
        int y = (int)(entityPlayer.field_70163_u + (double)entityPlayer.getDefaultEyeHeight());
        int z = (int)Math.floor(entityPlayer.field_70161_v);
        int prevX = (int)Math.floor(entityPlayer.field_70169_q);
        int prevY = (int)(entityPlayer.field_70167_r + (double)entityPlayer.getDefaultEyeHeight());
        int prevZ = (int)Math.floor(entityPlayer.field_70166_s);
        if (Minecraft.func_71410_x().field_71441_e != null) {
            Block currentBlockEyesIn = Minecraft.func_71410_x().field_71441_e.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
            Block pastBlockEyesIn = Minecraft.func_71410_x().field_71441_e.func_180495_p(new BlockPos(prevX, prevY, prevZ)).func_177230_c();
            return currentBlockEyesIn.equals(Blocks.field_150358_i) ^ pastBlockEyesIn.equals(Blocks.field_150358_i) || currentBlockEyesIn.equals(Blocks.field_150355_j) ^ pastBlockEyesIn.equals(Blocks.field_150355_j);
        }
        return false;
    }
}

