/*
 * Decompiled with CFR 0.152.
 */
package com.sonicjumper.enhancedvisuals.event;

import com.sonicjumper.enhancedvisuals.Base;
import com.sonicjumper.enhancedvisuals.death.DeathMessages;
import com.sonicjumper.enhancedvisuals.render.RenderVisual;
import com.sonicjumper.enhancedvisuals.shaders.ShaderGroupCustom;
import com.sonicjumper.enhancedvisuals.visuals.Visual;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGameOver;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class VisualRenderer {
    private HashMap<Class, RenderVisual> rendererMapStore = new HashMap();
    public static Minecraft mc = Minecraft.func_71410_x();
    private String lastRenderedMessage = null;

    @SubscribeEvent
    public void onRenderTick(RenderGameOverlayEvent event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.HOTBAR || event.isCancelable()) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            if (!(VisualRenderer.mc.field_71462_r instanceof GuiGameOver)) {
                this.lastRenderedMessage = null;
                this.renderStuff(event.renderTickTime);
                if (VisualRenderer.mc.field_71439_g == null) {
                    Base.instance.eventHandler.onTickInGame(Minecraft.func_71410_x().field_71439_g != null);
                }
            } else {
                if (this.lastRenderedMessage == null) {
                    this.lastRenderedMessage = DeathMessages.pickRandomDeathMessage();
                }
                VisualRenderer.mc.field_71466_p.func_78276_b("\"" + this.lastRenderedMessage + "\"", VisualRenderer.mc.field_71462_r.field_146294_l / 2 - VisualRenderer.mc.field_71466_p.func_78256_a(this.lastRenderedMessage) / 2, 114, 0xFFFFFF);
            }
        }
    }

    private void renderStuff(float partialTicks) {
        ArrayList<Visual> visualList;
        int i;
        if (Base.instance != null && Base.instance.shaderHelper != null) {
            ArrayList<ShaderGroupCustom> groups = Base.instance.shaderHelper.getShaderGroups();
            for (i = 0; i < groups.size(); ++i) {
                if (!groups.get(i).needNewFrameBuffer(VisualRenderer.mc.field_71443_c, VisualRenderer.mc.field_71440_d)) continue;
                groups.get(i).createBindFramebuffers(VisualRenderer.mc.field_71443_c, VisualRenderer.mc.field_71440_d, mc.func_147110_a());
            }
        }
        if ((visualList = Base.instance.manager.getActiveVisuals()).size() > 0) {
            this.setupOverlayRendering();
            GlStateManager.func_179147_l();
            GlStateManager.func_179097_i();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179118_c();
            GL11.glEnable((int)3042);
            try {
                for (i = 0; i < visualList.size(); ++i) {
                    Visual v = visualList.get(i);
                    v.getRenderer().renderVisual(v, partialTicks);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Base.instance.shaderHelper.drawShaders(partialTicks);
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179126_j();
            GlStateManager.func_179141_d();
            GlStateManager.func_179140_f();
        }
    }

    public void setupOverlayRendering() {
        ScaledResolution scaledresolution = new ScaledResolution(Minecraft.func_71410_x());
        GlStateManager.func_179086_m((int)256);
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179096_D();
        GlStateManager.func_179130_a((double)0.0, (double)scaledresolution.func_78327_c(), (double)scaledresolution.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179096_D();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2000.0f);
    }

    public RenderVisual getRendererForClass(Class<? extends RenderVisual> clazz) {
        if (!this.rendererMapStore.containsKey(clazz)) {
            try {
                this.rendererMapStore.put(clazz, clazz.newInstance());
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return this.rendererMapStore.get(clazz);
    }
}

