/*
 * Decompiled with CFR 0.152.
 */
package com.sonicjumper.enhancedvisuals.shaders;

import com.google.gson.JsonSyntaxException;
import com.sonicjumper.enhancedvisuals.Base;
import com.sonicjumper.enhancedvisuals.shaders.ShaderGroupCustom;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;

public class ShaderHelper {
    private Minecraft mc;
    private IResourceManager resourceManager;
    private ArrayList<ShaderGroupCustom> groups = new ArrayList();
    private ArrayList<String> shaders = new ArrayList();
    private boolean useShader;

    public ShaderHelper(Minecraft minecraft, IResourceManager resourceManager) {
        this.mc = minecraft;
        this.resourceManager = resourceManager;
    }

    public boolean isShaderActive(String name) {
        return this.shaders.contains(name);
    }

    public void loadShader(String name, ResourceLocation shadersPostLocation) {
        try {
            ShaderGroupCustom group = new ShaderGroupCustom(this.mc.func_110434_K(), this.resourceManager, this.mc.func_147110_a(), shadersPostLocation);
            group.createBindFramebuffers(this.mc.field_71443_c, this.mc.field_71440_d, this.mc.func_147110_a());
            this.groups.add(group);
            this.shaders.add(name);
        }
        catch (IOException ioexception) {
            Base.log.warn("Failed to load shader: " + shadersPostLocation, (Throwable)ioexception);
        }
        catch (JsonSyntaxException jsonsyntaxexception) {
            Base.log.warn("Failed to load shader: " + shadersPostLocation, (Throwable)jsonsyntaxexception);
        }
        this.useShader = this.groups.size() > 0;
    }

    public void drawShaders(float partialTicks) {
        if (this.groups.size() > 0 && this.useShader) {
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179094_E();
            GlStateManager.func_179096_D();
            for (int i = 0; i < this.groups.size(); ++i) {
                this.groups.get(i).loadShaderGroup(partialTicks);
            }
            GlStateManager.func_179121_F();
        }
        this.mc.func_147110_a().func_147610_a(false);
        GlStateManager.func_179128_n((int)5888);
    }

    public ShaderGroupCustom getShaderGroup(String name) {
        int index = this.shaders.indexOf(name);
        if (index != -1) {
            return this.groups.get(index);
        }
        return null;
    }

    public ArrayList<ShaderGroupCustom> getShaderGroups() {
        return this.groups;
    }

    public void removeShader(String name) {
        int index = this.shaders.indexOf(name);
        if (index != -1) {
            this.shaders.remove(index);
            this.groups.remove(index);
        }
        this.useShader = this.groups.size() > 0;
    }
}

