/*
 * Decompiled with CFR 0.152.
 */
package com.sonicjumper.enhancedvisuals.shaders.util;

import com.sonicjumper.enhancedvisuals.shaders.util.VertexAttrib;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.List;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.vector.Matrix3f;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;
import org.lwjgl.util.vector.Vector4f;

public class ShaderProgram {
    private static FloatBuffer fbuf16;
    private static IntBuffer ibuf4;
    public static final int VERTEX_SHADER = 35633;
    public static final int FRAGMENT_SHADER = 35632;
    private static boolean strict;
    protected int program;
    protected String log = "";
    protected HashMap<String, Integer> uniforms = new HashMap();
    protected Attrib[] attributes;
    protected String vertShaderSource;
    protected String fragShaderSource;
    protected int vert;
    protected int frag;

    public static boolean isSupported() {
        ContextCapabilities c = GLContext.getCapabilities();
        return c.GL_ARB_shader_objects && c.GL_ARB_vertex_shader && c.GL_ARB_fragment_shader;
    }

    public static void setStrictMode(boolean enabled) {
        strict = enabled;
    }

    public static boolean isStrictMode() {
        return strict;
    }

    public ShaderProgram(String vertexShaderSource, String fragShaderSource, List<VertexAttrib> attribLocations) throws LWJGLException {
        if (vertexShaderSource == null || fragShaderSource == null) {
            throw new IllegalArgumentException("shader source must be non-null");
        }
        if (!ShaderProgram.isSupported()) {
            throw new LWJGLException("no shader support found; shaders require OpenGL 2.0");
        }
        this.vertShaderSource = vertexShaderSource;
        this.fragShaderSource = fragShaderSource;
        this.vert = this.compileShader(35633, vertexShaderSource);
        this.frag = this.compileShader(35632, fragShaderSource);
        this.program = this.createProgram();
        try {
            this.linkProgram(attribLocations);
        }
        catch (LWJGLException e) {
            this.dispose();
            throw e;
        }
    }

    public ShaderProgram(String vertexShaderSource, String fragShaderSource) throws LWJGLException {
        this(vertexShaderSource, fragShaderSource, null);
    }

    protected ShaderProgram() {
    }

    protected int createProgram() throws LWJGLException {
        int program = GL20.glCreateProgram();
        if (program == 0) {
            throw new LWJGLException("could not create program; check ShaderProgram.isSupported()");
        }
        return program;
    }

    private String shaderTypeString(int type) {
        if (type == 35632) {
            return "FRAGMENT_SHADER";
        }
        if (type == 35633) {
            return "VERTEX_SHADER";
        }
        if (type == 36313) {
            return "GEOMETRY_SHADER";
        }
        return "shader";
    }

    protected int compileShader(int type, String source) throws LWJGLException {
        int shader = GL20.glCreateShader((int)type);
        if (shader == 0) {
            throw new LWJGLException("could not create shader object; check ShaderProgram.isSupported()");
        }
        GL20.glShaderSource((int)shader, (CharSequence)source);
        GL20.glCompileShader((int)shader);
        int comp = GL20.glGetShaderi((int)shader, (int)35713);
        int len = GL20.glGetShaderi((int)shader, (int)35716);
        String t = this.shaderTypeString(type);
        String err = GL20.glGetShaderInfoLog((int)shader, (int)len);
        if (err != null && err.length() != 0) {
            this.log = this.log + t + " compile log:\n" + err + "\n";
        }
        if (comp == 0) {
            throw new LWJGLException(this.log.length() != 0 ? this.log : "Could not compile " + this.shaderTypeString(type));
        }
        return shader;
    }

    protected void attachShaders() {
        GL20.glAttachShader((int)this.getID(), (int)this.vert);
        GL20.glAttachShader((int)this.getID(), (int)this.frag);
    }

    protected void linkProgram(List<VertexAttrib> attribLocations) throws LWJGLException {
        if (!this.valid()) {
            throw new LWJGLException("trying to link an invalid (i.e. released) program");
        }
        this.uniforms.clear();
        if (attribLocations != null) {
            for (VertexAttrib a : attribLocations) {
                if (a == null) continue;
                GL20.glBindAttribLocation((int)this.program, (int)a.location, (CharSequence)a.name);
            }
        }
        this.attachShaders();
        GL20.glLinkProgram((int)this.program);
        int comp = GL20.glGetProgrami((int)this.program, (int)35714);
        int len = GL20.glGetProgrami((int)this.program, (int)35716);
        String err = GL20.glGetProgramInfoLog((int)this.program, (int)len);
        if (err != null && err.length() != 0) {
            this.log = err + "\n" + this.log;
        }
        if (this.log != null) {
            this.log = this.log.trim();
        }
        if (comp == 0) {
            throw new LWJGLException(this.log.length() != 0 ? this.log : "Could not link program");
        }
        this.fetchUniforms();
        this.fetchAttributes();
    }

    public String getLog() {
        return this.log;
    }

    public void use() {
        if (!this.valid()) {
            throw new IllegalStateException("trying to enable a program that is not valid");
        }
        GL20.glUseProgram((int)this.program);
    }

    public void disposeShaders() {
        if (this.vert != 0) {
            GL20.glDetachShader((int)this.getID(), (int)this.vert);
            GL20.glDeleteShader((int)this.vert);
            this.vert = 0;
        }
        if (this.frag != 0) {
            GL20.glDetachShader((int)this.getID(), (int)this.frag);
            GL20.glDeleteShader((int)this.frag);
            this.frag = 0;
        }
    }

    public void dispose() {
        if (this.program != 0) {
            this.disposeShaders();
            GL20.glDeleteProgram((int)this.program);
            this.program = 0;
        }
    }

    public int getVertexShaderID() {
        return this.vert;
    }

    public int getFragmentShaderID() {
        return this.frag;
    }

    public String getVertexShaderSource() {
        return this.vertShaderSource;
    }

    public String getFragmentShaderSource() {
        return this.fragShaderSource;
    }

    public int getID() {
        return this.program;
    }

    public boolean valid() {
        return this.program != 0;
    }

    private void fetchUniforms() {
        int len = GL20.glGetProgrami((int)this.program, (int)35718);
        int strLen = GL20.glGetProgrami((int)this.program, (int)35719);
        for (int i = 0; i < len; ++i) {
            String name = GL20.glGetActiveUniform((int)this.program, (int)i, (int)strLen);
            int id = GL20.glGetUniformLocation((int)this.program, (CharSequence)name);
            this.uniforms.put(name, id);
        }
    }

    private void fetchAttributes() {
        int len = GL20.glGetProgrami((int)this.program, (int)35721);
        int strLen = GL20.glGetProgrami((int)this.program, (int)35722);
        this.attributes = new Attrib[len];
        for (int i = 0; i < len; ++i) {
            Attrib a = new Attrib();
            a.name = GL20.glGetActiveAttrib((int)this.program, (int)i, (int)strLen);
            a.size = GL20.glGetActiveAttribSize((int)this.program, (int)i);
            a.type = GL20.glGetActiveAttribType((int)this.program, (int)i);
            a.location = GL20.glGetAttribLocation((int)this.program, (CharSequence)a.name);
            this.attributes[i] = a;
        }
    }

    public int getUniformLocation(String name) {
        int location = -1;
        Integer locI = this.uniforms.get(name);
        if (locI == null) {
            location = GL20.glGetUniformLocation((int)this.program, (CharSequence)name);
            this.uniforms.put(name, location);
        } else {
            location = locI;
        }
        if (location == -1 && strict) {
            throw new IllegalArgumentException("no active uniform by name '" + name + "' (disable strict compiling to suppress warnings)");
        }
        return location;
    }

    Attrib attrib(String name) {
        for (int i = 0; i < this.attributes.length; ++i) {
            if (!name.equals(this.attributes[i].name)) continue;
            return this.attributes[i];
        }
        if (strict) {
            throw new IllegalArgumentException("no active attribute by name '" + name + "' (disable strict compiling to suppress warnings)");
        }
        return null;
    }

    public int getAttributeLocation(String name) {
        Attrib a = this.attrib(name);
        return a != null ? a.location : -1;
    }

    public int getAttributeType(String name) {
        Attrib a = this.attrib(name);
        return a != null ? a.type : -1;
    }

    public int getAttributeSize(String name) {
        Attrib a = this.attrib(name);
        return a != null ? a.size : -1;
    }

    public String[] getAttributeNames() {
        String[] s = new String[this.attributes.length];
        for (int i = 0; i < this.attributes.length; ++i) {
            s[i] = this.attributes[i].name;
        }
        return s;
    }

    public String[] getUniformNames() {
        return this.uniforms.keySet().toArray(new String[this.uniforms.size()]);
    }

    public boolean hasUniform(String name) {
        return this.uniforms.containsKey(name);
    }

    public boolean hasAttribute(String name) {
        for (int i = 0; i < this.attributes.length; ++i) {
            if (!name.equals(this.attributes[i].name)) continue;
            return true;
        }
        return false;
    }

    private FloatBuffer uniformf(int loc) {
        if (fbuf16 == null) {
            fbuf16 = BufferUtils.createFloatBuffer((int)16);
        }
        fbuf16.clear();
        if (loc == -1) {
            return fbuf16;
        }
        this.getUniform(loc, fbuf16);
        return fbuf16;
    }

    private IntBuffer uniformi(int loc) {
        if (ibuf4 == null) {
            ibuf4 = BufferUtils.createIntBuffer((int)4);
        }
        ibuf4.clear();
        if (loc == -1) {
            return ibuf4;
        }
        this.getUniform(loc, ibuf4);
        return ibuf4;
    }

    public void getUniform(int loc, FloatBuffer buf) {
        GL20.glGetUniform((int)this.program, (int)loc, (FloatBuffer)buf);
    }

    public void getUniform(int loc, IntBuffer buf) {
        GL20.glGetUniform((int)this.program, (int)loc, (IntBuffer)buf);
    }

    public boolean getUniform(String name, FloatBuffer buf) {
        int id = this.getUniformLocation(name);
        if (id == -1) {
            return false;
        }
        this.getUniform(id, buf);
        return true;
    }

    public boolean getUniform(String name, IntBuffer buf) {
        int id = this.getUniformLocation(name);
        if (id == -1) {
            return false;
        }
        this.getUniform(id, buf);
        return true;
    }

    public int getUniform1i(int loc) {
        return this.uniformi(loc).get(0);
    }

    public int getUniform1i(String name) {
        return this.getUniform1i(this.getUniformLocation(name));
    }

    public int[] getUniform2i(int loc) {
        IntBuffer buf = this.uniformi(loc);
        return new int[]{buf.get(0), buf.get(1)};
    }

    public int[] getUniform2i(String name) {
        return this.getUniform2i(this.getUniformLocation(name));
    }

    public int[] getUniform3i(int loc) {
        IntBuffer buf = this.uniformi(loc);
        return new int[]{buf.get(0), buf.get(1), buf.get(2)};
    }

    public int[] getUniform3i(String name) {
        return this.getUniform3i(this.getUniformLocation(name));
    }

    public int[] getUniform4i(int loc) {
        IntBuffer buf = this.uniformi(loc);
        return new int[]{buf.get(0), buf.get(1), buf.get(2), buf.get(3)};
    }

    public int[] getUniform4i(String name) {
        return this.getUniform4i(this.getUniformLocation(name));
    }

    public float getUniform1f(int loc) {
        return this.uniformf(loc).get(0);
    }

    public float getUniform1f(String name) {
        return this.getUniform1f(this.getUniformLocation(name));
    }

    public float[] getUniform2f(int loc) {
        FloatBuffer buf = this.uniformf(loc);
        return new float[]{buf.get(0), buf.get(1)};
    }

    public float[] getUniform2f(String name) {
        return this.getUniform2f(this.getUniformLocation(name));
    }

    public float[] getUniform3f(int loc) {
        FloatBuffer buf = this.uniformf(loc);
        return new float[]{buf.get(0), buf.get(1), buf.get(2)};
    }

    public float[] getUniform3f(String name) {
        return this.getUniform3f(this.getUniformLocation(name));
    }

    public float[] getUniform4f(int loc) {
        FloatBuffer buf = this.uniformf(loc);
        return new float[]{buf.get(0), buf.get(1), buf.get(2), buf.get(3)};
    }

    public float[] getUniform4f(String name) {
        return this.getUniform4f(this.getUniformLocation(name));
    }

    public void setUniformf(int loc, float f) {
        if (loc == -1) {
            return;
        }
        GL20.glUniform1f((int)loc, (float)f);
    }

    public void setUniformf(int loc, float a, float b) {
        if (loc == -1) {
            return;
        }
        GL20.glUniform2f((int)loc, (float)a, (float)b);
    }

    public void setUniformf(int loc, float a, float b, float c) {
        if (loc == -1) {
            return;
        }
        GL20.glUniform3f((int)loc, (float)a, (float)b, (float)c);
    }

    public void setUniformf(int loc, float a, float b, float c, float d) {
        if (loc == -1) {
            return;
        }
        GL20.glUniform4f((int)loc, (float)a, (float)b, (float)c, (float)d);
    }

    public void setUniformi(int loc, int i) {
        if (loc == -1) {
            return;
        }
        GL20.glUniform1i((int)loc, (int)i);
    }

    public void setUniformi(int loc, int a, int b) {
        if (loc == -1) {
            return;
        }
        GL20.glUniform2i((int)loc, (int)a, (int)b);
    }

    public void setUniformi(int loc, int a, int b, int c) {
        if (loc == -1) {
            return;
        }
        GL20.glUniform3i((int)loc, (int)a, (int)b, (int)c);
    }

    public void setUniformi(int loc, int a, int b, int c, int d) {
        if (loc == -1) {
            return;
        }
        GL20.glUniform4i((int)loc, (int)a, (int)b, (int)c, (int)d);
    }

    public void setUniformf(String name, float f) {
        this.setUniformf(this.getUniformLocation(name), f);
    }

    public void setUniformf(String name, float a, float b) {
        this.setUniformf(this.getUniformLocation(name), a, b);
    }

    public void setUniformf(String name, float a, float b, float c) {
        this.setUniformf(this.getUniformLocation(name), a, b, c);
    }

    public void setUniformf(String name, float a, float b, float c, float d) {
        this.setUniformf(this.getUniformLocation(name), a, b, c, d);
    }

    public void setUniformi(String name, int i) {
        this.setUniformi(this.getUniformLocation(name), i);
    }

    public void setUniformi(String name, int a, int b) {
        this.setUniformi(this.getUniformLocation(name), a, b);
    }

    public void setUniformi(String name, int a, int b, int c) {
        this.setUniformi(this.getUniformLocation(name), a, b, c);
    }

    public void setUniformi(String name, int a, int b, int c, int d) {
        this.setUniformi(this.getUniformLocation(name), a, b, c, d);
    }

    public void setUniformMatrix(String name, boolean transpose, Matrix3f m) {
        this.setUniformMatrix(this.getUniformLocation(name), transpose, m);
    }

    public void setUniformMatrix(String name, boolean transpose, Matrix4f m) {
        this.setUniformMatrix(this.getUniformLocation(name), transpose, m);
    }

    public void setUniformMatrix(int loc, boolean transpose, Matrix3f m) {
        if (loc == -1) {
            return;
        }
        if (fbuf16 == null) {
            fbuf16 = BufferUtils.createFloatBuffer((int)16);
        }
        fbuf16.clear();
        m.store(fbuf16);
        fbuf16.flip();
        GL20.glUniformMatrix3((int)loc, (boolean)transpose, (FloatBuffer)fbuf16);
    }

    public void setUniformMatrix(int loc, boolean transpose, Matrix4f m) {
        if (loc == -1) {
            return;
        }
        if (fbuf16 == null) {
            fbuf16 = BufferUtils.createFloatBuffer((int)16);
        }
        fbuf16.clear();
        m.store(fbuf16);
        fbuf16.flip();
        GL20.glUniformMatrix4((int)loc, (boolean)transpose, (FloatBuffer)fbuf16);
    }

    public void setUniformf(String name, Vector2f v) {
        this.setUniformf(this.getUniformLocation(name), v);
    }

    public void setUniformf(String name, Vector3f v) {
        this.setUniformf(this.getUniformLocation(name), v);
    }

    public void setUniformf(String name, Vector4f v) {
        this.setUniformf(this.getUniformLocation(name), v);
    }

    public void setUniformf(int loc, Vector2f v) {
        if (loc == -1) {
            return;
        }
        this.setUniformf(loc, v.x, v.y);
    }

    public void setUniformf(int loc, Vector3f v) {
        if (loc == -1) {
            return;
        }
        this.setUniformf(loc, v.x, v.y, v.z);
    }

    public void setUniformf(int loc, Vector4f v) {
        if (loc == -1) {
            return;
        }
        this.setUniformf(loc, v.x, v.y, v.z, v.w);
    }

    static {
        strict = false;
    }

    protected static class Attrib {
        String name = null;
        int type = -1;
        int size = 0;
        int location = -1;

        protected Attrib() {
        }
    }
}

