/*
 * Decompiled with CFR 0.152.
 */
package com.sonicjumper.enhancedvisuals.shaders.util;

import com.sonicjumper.enhancedvisuals.shaders.util.Color;
import com.sonicjumper.enhancedvisuals.shaders.util.ITexture;
import com.sonicjumper.enhancedvisuals.shaders.util.MathUtil;
import com.sonicjumper.enhancedvisuals.shaders.util.ShaderProgram;
import com.sonicjumper.enhancedvisuals.shaders.util.Texture;
import com.sonicjumper.enhancedvisuals.shaders.util.TextureRegion;
import com.sonicjumper.enhancedvisuals.shaders.util.VertexArray;
import com.sonicjumper.enhancedvisuals.shaders.util.VertexAttrib;
import com.sonicjumper.enhancedvisuals.shaders.util.VertexData;
import java.nio.FloatBuffer;
import java.util.Arrays;
import java.util.List;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;
import org.lwjgl.util.vector.Matrix4f;

public class SpriteBatch {
    public static final String U_TEXTURE = "u_texture";
    public static final String U_PROJ_VIEW = "u_projView";
    public static final String ATTR_COLOR = "Color";
    public static final String ATTR_POSITION = "Position";
    public static final String ATTR_TEXCOORD = "TexCoord";
    public static final String DEFAULT_VERT_SHADER = "uniform mat4 u_projView;\nattribute vec4 Color;\nattribute vec2 TexCoord;\nattribute vec2 Position;\nvarying vec4 vColor;\nvarying vec2 vTexCoord; \nvoid main() {\n\tvColor = Color;\n\tvTexCoord = TexCoord;\n\tgl_Position = u_projView * vec4(Position.xy, 0.0, 1.0);\n}";
    public static final String DEFAULT_FRAG_SHADER = "uniform sampler2D u_texture;\nvarying vec4 vColor;\nvarying vec2 vTexCoord;\nvoid main() {\n\tvec4 texColor = texture2D(u_texture, vTexCoord);\n\tgl_FragColor = vColor * texColor;\n}";
    public static final List<VertexAttrib> ATTRIBUTES = Arrays.asList(new VertexAttrib(0, "Position", 2), new VertexAttrib(1, "Color", 4), new VertexAttrib(2, "TexCoord", 2));
    static ShaderProgram defaultShader;
    public static int renderCalls;
    protected FloatBuffer buf16;
    protected Matrix4f projMatrix = new Matrix4f();
    protected Matrix4f viewMatrix = new Matrix4f();
    protected Matrix4f transpositionPool = new Matrix4f();
    private Matrix4f projViewMatrix = new Matrix4f();
    protected Texture texture;
    protected ShaderProgram program;
    protected VertexData data;
    private int idx;
    private int maxIndex;
    private Color color = new Color();
    private boolean drawing = false;

    public static ShaderProgram getDefaultShader() throws LWJGLException {
        return defaultShader == null ? (defaultShader = new ShaderProgram(DEFAULT_VERT_SHADER, DEFAULT_FRAG_SHADER, ATTRIBUTES)) : defaultShader;
    }

    public SpriteBatch(ShaderProgram program) {
        this(program, 1000);
    }

    public SpriteBatch(ShaderProgram program, int size) {
        this(program, 1000, true);
    }

    public SpriteBatch(ShaderProgram program, int size, boolean updateUniforms) {
        this.program = program;
        this.data = new VertexArray(size * 6, ATTRIBUTES);
        this.maxIndex = size * 6;
        this.resize(Display.getWidth(), Display.getHeight());
    }

    public SpriteBatch(int size) throws LWJGLException {
        this(SpriteBatch.getDefaultShader(), size);
    }

    public SpriteBatch() throws LWJGLException {
        this(1000);
    }

    public Matrix4f getViewMatrix() {
        return this.viewMatrix;
    }

    public Matrix4f getProjectionMatrix() {
        return this.projMatrix;
    }

    public Matrix4f getCombinedMatrix() {
        Matrix4f.mul((Matrix4f)Matrix4f.transpose((Matrix4f)this.projMatrix, (Matrix4f)this.transpositionPool), (Matrix4f)this.viewMatrix, (Matrix4f)this.projViewMatrix);
        return this.projViewMatrix;
    }

    public void resize(int width, int height) {
        this.projMatrix = MathUtil.toOrtho2D(this.projMatrix, 0.0f, 0.0f, width, height);
        this.updateUniforms();
    }

    public void setColor(Color color) {
        this.setColor(color.r, color.g, color.b, color.a);
    }

    public void setColor(float r, float g, float b, float a) {
        this.color.set(r, g, b, a);
    }

    public void updateUniforms() {
        this.updateUniforms(this.program);
    }

    public void updateUniforms(ShaderProgram program) {
        this.projViewMatrix = this.getCombinedMatrix();
        program.use();
        boolean oldStrict = ShaderProgram.isStrictMode();
        ShaderProgram.setStrictMode(false);
        program.setUniformMatrix(U_PROJ_VIEW, false, this.projViewMatrix);
        program.setUniformi(U_TEXTURE, 0);
        ShaderProgram.setStrictMode(oldStrict);
    }

    public void setShader(ShaderProgram program, boolean updateUniforms) {
        if (program == null) {
            throw new NullPointerException("shader cannot be null; use getDefaultShader instead");
        }
        if (this.drawing) {
            this.flush();
        }
        this.program = program;
        if (updateUniforms) {
            this.updateUniforms();
        } else if (this.drawing) {
            program.use();
        }
    }

    public void setShader(ShaderProgram program) {
        this.setShader(program, true);
    }

    public ShaderProgram getShader() {
        return this.program;
    }

    public void begin() {
        if (this.drawing) {
            throw new IllegalStateException("must not be drawing before calling begin()");
        }
        this.drawing = true;
        this.program.use();
        this.idx = 0;
        renderCalls = 0;
        this.texture = null;
    }

    public void end() {
        if (!this.drawing) {
            throw new IllegalStateException("must be drawing before calling end()");
        }
        this.drawing = false;
        this.flush();
    }

    public void flush() {
        if (this.idx > 0) {
            this.data.flip();
            this.render();
            this.idx = 0;
            this.data.clear();
        }
    }

    public void drawRegion(Texture tex, float srcX, float srcY, float srcWidth, float srcHeight, float dstX, float dstY) {
        this.drawRegion(tex, srcX, srcY, srcWidth, srcHeight, dstX, dstY, srcWidth, srcHeight);
    }

    public void drawRegion(Texture tex, float srcX, float srcY, float srcWidth, float srcHeight, float dstX, float dstY, float dstWidth, float dstHeight) {
        float u = srcX / (float)tex.getWidth();
        float v = srcY / (float)tex.getHeight();
        float u2 = (srcX + srcWidth) / (float)tex.getWidth();
        float v2 = (srcY + srcHeight) / (float)tex.getHeight();
        this.draw(tex, dstX, dstY, dstWidth, dstHeight, u, v, u2, v2);
    }

    public void drawRegion(TextureRegion region, float srcX, float srcY, float srcWidth, float srcHeight, float dstX, float dstY) {
        this.drawRegion(region, srcX, srcY, srcWidth, srcHeight, dstX, dstY, srcWidth, srcHeight);
    }

    public void drawRegion(TextureRegion region, float srcX, float srcY, float srcWidth, float srcHeight, float dstX, float dstY, float dstWidth, float dstHeight) {
        this.drawRegion(region.getTexture(), (float)region.getRegionX() + srcX, (float)region.getRegionY() + srcY, srcWidth, srcHeight, dstX, dstY, dstWidth, dstHeight);
    }

    public void draw(ITexture tex, float x, float y) {
        this.draw(tex, x, y, tex.getWidth(), tex.getHeight());
    }

    public void draw(ITexture tex, float x, float y, float width, float height) {
        this.draw(tex, x, y, width, height, tex.getU(), tex.getV(), tex.getU2(), tex.getV2());
    }

    public void draw(ITexture tex, float x, float y, float originX, float originY, float rotationRadians) {
        this.draw(tex, x, y, tex.getWidth(), tex.getHeight(), originX, originY, rotationRadians);
    }

    public void draw(ITexture tex, float x, float y, float width, float height, float originX, float originY, float rotationRadians) {
        this.draw(tex, x, y, width, height, originX, originY, rotationRadians, tex.getU(), tex.getV(), tex.getU2(), tex.getV2());
    }

    public void draw(ITexture tex, float x, float y, float width, float height, float originX, float originY, float rotationRadians, float u, float v, float u2, float v2) {
        float y4;
        float x4;
        float y3;
        float x3;
        float y2;
        float x2;
        float y1;
        float x1;
        this.checkFlush(tex);
        float r = this.color.r;
        float g = this.color.g;
        float b = this.color.b;
        float a = this.color.a;
        if (rotationRadians != 0.0f) {
            float scaleX = 1.0f;
            float scaleY = 1.0f;
            float cx = originX * scaleX;
            float cy = originY * scaleY;
            float p1x = -cx;
            float p1y = -cy;
            float p2x = width - cx;
            float p2y = -cy;
            float p3x = width - cx;
            float p3y = height - cy;
            float p4x = -cx;
            float p4y = height - cy;
            float cos = (float)Math.cos(rotationRadians);
            float sin = (float)Math.sin(rotationRadians);
            x1 = x + (cos * p1x - sin * p1y) + cx;
            y1 = y + (sin * p1x + cos * p1y) + cy;
            x2 = x + (cos * p2x - sin * p2y) + cx;
            y2 = y + (sin * p2x + cos * p2y) + cy;
            x3 = x + (cos * p3x - sin * p3y) + cx;
            y3 = y + (sin * p3x + cos * p3y) + cy;
            x4 = x + (cos * p4x - sin * p4y) + cx;
            y4 = y + (sin * p4x + cos * p4y) + cy;
        } else {
            x1 = x;
            y1 = y;
            x2 = x + width;
            y2 = y;
            x3 = x + width;
            y3 = y + height;
            x4 = x;
            y4 = y + height;
        }
        this.vertex(x1, y1, r, g, b, a, u, v);
        this.vertex(x2, y2, r, g, b, a, u2, v);
        this.vertex(x4, y4, r, g, b, a, u, v2);
        this.vertex(x2, y2, r, g, b, a, u2, v);
        this.vertex(x3, y3, r, g, b, a, u2, v2);
        this.vertex(x4, y4, r, g, b, a, u, v2);
    }

    public void draw(ITexture tex, float x, float y, float width, float height, float u, float v, float u2, float v2) {
        this.draw(tex, x, y, width, height, x, y, 0.0f, u, v, u2, v2);
    }

    public void draw(ITexture tex, float[] vertices, int offset) {
        this.checkFlush(tex);
        this.data.put(vertices, offset, this.data.getTotalNumComponents() * 6);
        this.idx += 6;
    }

    VertexData vertex(float x, float y, float r, float g, float b, float a, float u, float v) {
        this.data.put(x).put(y).put(r).put(g).put(b).put(a).put(u).put(v);
        ++this.idx;
        return this.data;
    }

    protected void checkFlush(ITexture sprite) {
        if (sprite == null || sprite.getTexture() == null) {
            throw new NullPointerException("null texture");
        }
        if (sprite.getTexture() != this.texture || this.idx >= this.maxIndex) {
            this.flush();
            this.texture = sprite.getTexture();
        }
    }

    private void render() {
        if (this.texture != null) {
            this.texture.bind();
        }
        this.data.bind();
        this.data.draw(4, 0, this.idx);
        this.data.unbind();
        ++renderCalls;
    }

    static {
        renderCalls = 0;
    }
}

