/*
 * Decompiled with CFR 0.152.
 */
package com.sonicjumper.enhancedvisuals.shaders.util;

import com.sonicjumper.enhancedvisuals.shaders.util.ITexture;
import com.sonicjumper.enhancedvisuals.shaders.util.Texture;

public class TextureRegion
implements ITexture {
    protected Texture texture;
    protected float u;
    protected float v;
    protected float u2;
    protected float v2;
    protected int regionWidth;
    protected int regionHeight;

    public TextureRegion(Texture texture) {
        this(texture, 0, 0);
    }

    public TextureRegion(Texture texture, int x, int y) {
        this(texture, x, y, texture.getWidth(), texture.getHeight());
    }

    public TextureRegion(Texture texture, int x, int y, int width, int height) {
        this.set(texture, x, y, width, height);
    }

    public TextureRegion(Texture texture, float u, float v, float u2, float v2) {
        this.set(texture, u, v, u2, v2);
    }

    public TextureRegion(TextureRegion region, int x, int y, int width, int height) {
        this.set(region, x, y, width, height);
    }

    public void set(Texture texture, int x, int y, int width, int height) {
        this.set(texture, (float)x / (float)texture.getWidth(), (float)y / (float)texture.getHeight(), (float)(x + width) / (float)texture.getWidth(), (float)(y + height) / (float)texture.getHeight());
        this.regionWidth = Math.round(width);
        this.regionHeight = Math.round(height);
    }

    public void set(Texture texture, float u, float v, float u2, float v2) {
        this.texture = texture;
        this.u = u;
        this.v = v;
        this.u2 = u2;
        this.v2 = v2;
        this.regionWidth = Math.round(Math.abs(u2 - u) * (float)texture.getWidth());
        this.regionHeight = Math.round(Math.abs(v2 - v) * (float)texture.getHeight());
    }

    public void set(TextureRegion region, int x, int y, int width, int height) {
        this.set(region.texture, x + region.getRegionX(), y + region.getRegionY(), width, height);
    }

    public int getRegionX() {
        return Math.round(this.u * (float)this.texture.getWidth());
    }

    public int getRegionY() {
        return Math.round(this.v * (float)this.texture.getHeight());
    }

    public void flip(boolean x, boolean y) {
        float temp;
        if (x) {
            temp = this.u;
            this.u = this.u2;
            this.u2 = temp;
        }
        if (y) {
            temp = this.v;
            this.v = this.v2;
            this.v2 = temp;
        }
    }

    @Override
    public Texture getTexture() {
        return this.texture;
    }

    public void setTexture(Texture texture) {
        this.texture = texture;
    }

    @Override
    public float getU() {
        return this.u;
    }

    public void setU(float u) {
        this.u = u;
    }

    @Override
    public float getV() {
        return this.v;
    }

    public void setV(float v) {
        this.v = v;
    }

    @Override
    public float getU2() {
        return this.u2;
    }

    public void setU2(float u2) {
        this.u2 = u2;
    }

    @Override
    public float getV2() {
        return this.v2;
    }

    public void setV2(float v2) {
        this.v2 = v2;
    }

    @Override
    public int getWidth() {
        return this.regionWidth;
    }

    @Override
    public int getHeight() {
        return this.regionHeight;
    }
}

