/*
 * Decompiled with CFR 0.152.
 */
package com.sonicjumper.enhancedvisuals.visuals;

import com.sonicjumper.enhancedvisuals.Base;
import com.sonicjumper.enhancedvisuals.ClientProxy;
import com.sonicjumper.enhancedvisuals.ConfigCore;
import com.sonicjumper.enhancedvisuals.visuals.Visual;
import com.sonicjumper.enhancedvisuals.visuals.types.BlurType;
import com.sonicjumper.enhancedvisuals.visuals.types.DrownType;
import com.sonicjumper.enhancedvisuals.visuals.types.DustType;
import com.sonicjumper.enhancedvisuals.visuals.types.FireType;
import com.sonicjumper.enhancedvisuals.visuals.types.SandType;
import com.sonicjumper.enhancedvisuals.visuals.types.SaturationType;
import com.sonicjumper.enhancedvisuals.visuals.types.SlenderType;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.compress.archivers.zip.ZipFile;

public class VisualType {
    public static ArrayList<VisualType> visuals = new ArrayList();
    public static VisualType splatter = new VisualType(Visual.VisualCatagory.splat, "splatter", "blood splatter", true);
    public static VisualType impact = new VisualType(Visual.VisualCatagory.splat, "impact", "blunt impact", true);
    public static VisualType slash = new VisualType(Visual.VisualCatagory.splat, "slash", "sharp slash", true);
    public static VisualType pierce = new VisualType(Visual.VisualCatagory.splat, "pierce", "arrow pierce", true);
    public static DustType dust = new DustType();
    public static FireType fire = new FireType();
    public static SandType sand = new SandType();
    public static DrownType waterS = new DrownType();
    public static VisualType lowhealth = new VisualType(Visual.VisualCatagory.overlay, "lowhealth", "heartbeat overlay");
    public static VisualType potion = new VisualType(Visual.VisualCatagory.overlay, "potion", "splash potion effect", true);
    public static SlenderType slender = new SlenderType();
    public static BlurType blur = new BlurType();
    public static SaturationType desaturate = new SaturationType();
    public boolean enabled = true;
    public float alpha = 1.0f;
    private Visual.VisualCatagory visualCatagory;
    private String visualName;
    public String comment;
    private String themePack;
    private Dimension imageDimensions;
    public ResourceLocation[] resourceArray;
    public boolean substractByTime;

    public VisualType(Visual.VisualCatagory catagory, String name, String comment) {
        this(catagory, name, comment, false);
    }

    public VisualType(Visual.VisualCatagory catagory, String name, String comment, boolean substractByTime) {
        this.substractByTime = substractByTime;
        this.comment = comment;
        visuals.add(this);
        this.visualCatagory = catagory;
        this.visualName = name.toLowerCase();
        try {
            this.createResources();
            for (ResourceLocation resourceLoc : this.resourceArray) {
                Base.log.info(resourceLoc.func_110623_a());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Base.log.error("[Enhanced Visuals] Could not find the directory, make sure you installed the mod correctly: " + ClientProxy.getVisualsDirectory(this.themePack) + this.visualCatagory.toString() + "/" + this.visualName);
        }
        if (this.resourceArray != null) {
            Base.log.info(this.visualCatagory.toString() + " || " + name + " || " + this.resourceArray.length);
        }
    }

    public void loadConfig(Configuration config) {
        this.enabled = config.getBoolean("enabled", this.getName(), true, this.comment);
        this.alpha = config.getFloat("alphaFactor", this.getName(), 1.0f, 0.0f, 1.0f, "alpha = normalAlpha * alphaFactor");
    }

    public void createResources() {
        this.themePack = ConfigCore.defaultThemePack;
        this.resourceArray = this.createResourcesForVisualType(this);
    }

    private ResourceLocation[] createResourcesForVisualType(VisualType vt) {
        LinkedList<ResourceLocation> result = new LinkedList<ResourceLocation>();
        String visualNamePath = this.themePack + "/visuals/" + vt.visualCatagory.toString() + "/" + vt.visualName + "/";
        File f = new File(ClientProxy.getVisualsDirectory(this.themePack) + this.visualCatagory.toString().toLowerCase() + "/" + this.visualName + "/");
        File[] list = f.listFiles();
        if (list != null) {
            int matchedIndex = 0;
            for (int i = 0; i < list.length; ++i) {
                if (!list[i].getName().toLowerCase().contains(this.visualName.toLowerCase())) continue;
                result.add(matchedIndex++, new ResourceLocation("enhancedvisuals", this.themePack + "/visuals/" + vt.visualCatagory.toString() + "/" + vt.visualName + "/" + list[i].getName()));
            }
            if (matchedIndex > 0) {
                File firstImage = new File(ClientProxy.getVisualsDirectory(this.themePack) + vt.visualCatagory.toString() + "/" + vt.visualName + "/" + new File(((ResourceLocation)result.get(0)).func_110623_a()).getName());
                try {
                    this.imageDimensions = this.getDimensionsOfImage(firstImage);
                }
                catch (Exception e) {
                    Base.log.warn("Could not read dimensions of image: " + f.getPath() + "; maybe it isn't an image?");
                }
            } else {
                this.imageDimensions = new Dimension(0, 0);
            }
        }
        if (result.size() == 0) {
            try {
                URL url = new File(ClientProxy.baseJarPath).toURI().toURL();
                InputStream in = url.openStream();
                ZipFile zipFile = new ZipFile(new File(ClientProxy.baseJarPath));
                ZipInputStream zip = new ZipInputStream(in);
                ZipEntry entry = null;
                while ((entry = zip.getNextEntry()) != null) {
                    String resourcePath = entry.getName().replace("assets/enhancedvisuals/", "");
                    String[] resourcePathArray = resourcePath.split("/");
                    if (!resourcePath.contains(visualNamePath) || resourcePath.equalsIgnoreCase(visualNamePath) || !resourcePathArray[resourcePathArray.length - 1].toLowerCase().contains(this.visualName.toLowerCase())) continue;
                    result.add(new ResourceLocation("enhancedvisuals", resourcePath));
                    try {
                        BufferedImage bi = ImageIO.read(zipFile.getInputStream(zipFile.getEntry(entry.getName())));
                        this.imageDimensions = new Dimension(bi.getWidth(), bi.getHeight());
                    }
                    catch (Exception e) {
                        Base.log.warn("Could not read dimensions of image: " + entry.getName() + "; maybe it isn't an image?");
                        this.imageDimensions = new Dimension(0, 0);
                    }
                }
                zipFile.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result.toArray(new ResourceLocation[0]);
    }

    private Dimension getDimensionsOfImage(File resourceFile) throws IOException {
        ImageInputStream in = ImageIO.createImageInputStream(resourceFile);
        return this.getDimensionsOfImage(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension getDimensionsOfImage(ImageInputStream in) throws IOException {
        try {
            Iterator<ImageReader> readers = ImageIO.getImageReaders(in);
            if (readers.hasNext()) {
                ImageReader reader = readers.next();
                try {
                    reader.setInput(in);
                    Dimension localDimension = new Dimension(reader.getWidth(0), reader.getHeight(0));
                    reader.dispose();
                    Dimension dimension = localDimension;
                    reader.dispose();
                    return dimension;
                }
                catch (Throwable throwable) {
                    reader.dispose();
                    throw throwable;
                }
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return new Dimension(0, 0);
    }

    public int getSize() {
        return this.imageDimensions != null ? this.imageDimensions.height : 0;
    }

    public Visual.VisualCatagory getCatagory() {
        return this.visualCatagory;
    }

    public String getName() {
        return this.visualName;
    }
}

