/*
 * Decompiled with CFR 0.152.
 */
package com.sonicjumper.enhancedvisuals;

import com.sonicjumper.enhancedvisuals.VisualManager;
import com.sonicjumper.enhancedvisuals.death.DeathMessages;
import com.sonicjumper.enhancedvisuals.events.VisualEventHandler;
import com.sonicjumper.enhancedvisuals.handlers.VisualHandler;
import com.sonicjumper.enhancedvisuals.visuals.VisualPersistent;
import com.sonicjumper.enhancedvisuals.visuals.types.VisualCategory;
import com.sonicjumper.enhancedvisuals.visuals.types.VisualType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="enhancedvisuals", name="Enhanced Visuals", acceptedMinecraftVersions="", clientSideOnly=true)
public class EnhancedVisuals {
    public static final String modid = "enhancedvisuals";
    public static final String name = "Enhanced Visuals";
    public static final String version = "1.1.0";
    public static Logger log = LogManager.getLogger((String)"enhancedvisuals");
    public static boolean noEffectsForCreative = false;

    @Mod.EventHandler
    public void init(FMLLoadCompleteEvent event) {
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a(new IResourceManagerReloadListener(){

            public void func_110549_a(IResourceManager resourceManager) {
                VisualManager.clearAllVisuals();
                for (int i = 0; i < VisualCategory.values().length; ++i) {
                    VisualCategory category = VisualCategory.values()[i];
                    for (int j = 0; j < category.types.size(); ++j) {
                        category.types.get(j).loadTextures(resourceManager);
                        VisualPersistent persistent = category.types.get(j).createPersitentVisual();
                        if (persistent == null) continue;
                        VisualManager.addPersistentVisual(persistent);
                    }
                }
            }
        });
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        noEffectsForCreative = config.getBoolean("noEffectsForCreative", "general", noEffectsForCreative, "If players in creative mod should have effects");
        VisualType.onLoad();
        for (int i = 0; i < VisualCategory.values().length; ++i) {
            VisualCategory category = VisualCategory.values()[i];
            for (int j = 0; j < category.types.size(); ++j) {
                category.types.get(j).initConfig(config);
            }
        }
        for (VisualHandler handler : VisualHandler.getAllHandlers()) {
            handler.initConfig(config);
        }
        VisualHandler.afterInit();
        DeathMessages.loadConfig(config);
        config.save();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register(VisualEventHandler.class);
    }
}

