/*
 * Decompiled with CFR 0.152.
 */
package com.sonicjumper.enhancedvisuals.handlers;

import com.sonicjumper.enhancedvisuals.VisualManager;
import com.sonicjumper.enhancedvisuals.handlers.VisualHandler;
import com.sonicjumper.enhancedvisuals.visuals.types.VisualType;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.config.Configuration;

public class DamageHandler
extends VisualHandler {
    public final ArrayList<Item> sharpList = new ArrayList();
    public final ArrayList<Item> bluntList = new ArrayList();
    public final ArrayList<Item> pierceList = new ArrayList();
    public static boolean hitEffect = false;
    public int fireSplashes = 1;
    public int fireMinDuration = 100;
    public int fireMaxDuration = 1000;
    public int drownSplashes = 4;
    public int drownMinDuration = 10;
    public int drownMaxDuration = 15;

    public DamageHandler() {
        super("damage", "when the player is taking damage");
    }

    @Override
    public void initConfig(Configuration config) {
        super.initConfig(config);
        this.sharpList.add(Items.field_151040_l);
        this.sharpList.add(Items.field_151041_m);
        this.sharpList.add(Items.field_151052_q);
        this.sharpList.add(Items.field_151048_u);
        this.sharpList.add(Items.field_151010_B);
        this.sharpList.add(Items.field_151036_c);
        this.sharpList.add(Items.field_151053_p);
        this.sharpList.add(Items.field_151049_t);
        this.sharpList.add(Items.field_151056_x);
        this.sharpList.add(Items.field_151006_E);
        this.bluntList.add(Items.field_151035_b);
        this.bluntList.add(Items.field_151039_o);
        this.bluntList.add(Items.field_151050_s);
        this.bluntList.add(Items.field_151046_w);
        this.bluntList.add(Items.field_151005_D);
        this.bluntList.add(Items.field_151037_a);
        this.bluntList.add(Items.field_151038_n);
        this.bluntList.add(Items.field_151051_r);
        this.bluntList.add(Items.field_151047_v);
        this.bluntList.add(Items.field_151011_C);
        this.pierceList.add(Items.field_151019_K);
        this.pierceList.add(Items.field_151017_I);
        this.pierceList.add(Items.field_151018_J);
        this.pierceList.add(Items.field_151012_L);
        this.pierceList.add(Items.field_151013_M);
        this.pierceList.add(Items.field_151032_g);
        hitEffect = config.getBoolean("hitEffect", this.name, hitEffect, "Red overlay effect once you get hit");
        this.fireSplashes = config.getInt("fireSplashes", this.name, this.fireSplashes, 0, 10000, "splashes per tick");
        this.fireMaxDuration = config.getInt("fireMaxDuration", this.name, this.fireMaxDuration, 1, 10000, "max duration of one particle");
        this.fireMinDuration = config.getInt("fireMinDuration", this.name, this.fireMinDuration, 1, 10000, "min duration of one particle");
        this.drownSplashes = config.getInt("drownSplashes", this.name, this.drownSplashes, 0, 10000, "splashes per hit");
        this.drownMaxDuration = config.getInt("drownMaxDuration", this.name, this.drownMaxDuration, 1, 10000, "max duration of one splash");
        this.drownMinDuration = config.getInt("drownMinDuration", this.name, this.drownMinDuration, 1, 10000, "min duration of one splash");
    }

    @Override
    public void onPlayerDamaged(EntityPlayer player, DamageSource source, float damage) {
        if (hitEffect) {
            VisualManager.addVisualWithShading(VisualType.damaged, 1.0f, 15, 20, new Color(1.0f, 1.0f, 1.0f, 0.2f));
        }
        Entity attacker = source.func_76364_f();
        double distanceSq = 1.0;
        if (attacker instanceof EntityArrow) {
            VisualManager.createVisualFromDamage(VisualType.pierce, damage, (EntityLivingBase)player);
        }
        if (attacker instanceof EntityLivingBase) {
            EntityLivingBase lastAttacker = (EntityLivingBase)attacker;
            if (lastAttacker.func_184614_ca() != null) {
                if (this.isSharp(lastAttacker.func_184614_ca().func_77973_b())) {
                    VisualManager.createVisualFromDamageAndDistance(VisualType.slash, damage, (EntityLivingBase)player, distanceSq);
                } else if (this.isBlunt(lastAttacker.func_184614_ca().func_77973_b())) {
                    VisualManager.createVisualFromDamageAndDistance(VisualType.impact, damage, (EntityLivingBase)player, distanceSq);
                } else if (this.isPierce(lastAttacker.func_184614_ca().func_77973_b())) {
                    VisualManager.createVisualFromDamageAndDistance(VisualType.pierce, damage, (EntityLivingBase)player, distanceSq);
                } else {
                    VisualManager.createVisualFromDamageAndDistance(VisualType.splatter, damage, (EntityLivingBase)player, distanceSq);
                }
            } else if (lastAttacker instanceof EntityZombie || lastAttacker instanceof EntitySkeleton || lastAttacker instanceof EntityOcelot) {
                VisualManager.createVisualFromDamageAndDistance(VisualType.slash, damage, (EntityLivingBase)player, distanceSq);
            } else if (lastAttacker instanceof EntityGolem || lastAttacker instanceof EntityPlayer) {
                VisualManager.createVisualFromDamageAndDistance(VisualType.impact, damage, (EntityLivingBase)player, distanceSq);
            } else if (lastAttacker instanceof EntityWolf || lastAttacker instanceof EntitySpider) {
                VisualManager.createVisualFromDamageAndDistance(VisualType.pierce, damage, (EntityLivingBase)player, distanceSq);
            }
        }
        if (source == DamageSource.field_76367_g) {
            VisualManager.createVisualFromDamage(VisualType.pierce, damage, (EntityLivingBase)player);
        }
        if (source == DamageSource.field_76379_h || source == DamageSource.field_82729_p) {
            VisualManager.createVisualFromDamage(VisualType.impact, damage, (EntityLivingBase)player);
        }
        if (source.equals(DamageSource.field_76369_e)) {
            VisualManager.addVisualsWithShading(VisualType.waterS, 1.0f, this.drownSplashes, this.drownMinDuration, this.drownMaxDuration, new Color(1.0f, 1.0f, 1.0f, 1.0f));
        }
        if (source.func_76347_k() || source == DamageSource.field_76370_b) {
            VisualManager.addVisualsWithShading(VisualType.fire, 1.0f, this.fireSplashes, this.fireMinDuration, this.fireMaxDuration, new Color(1, 1, 1));
        }
    }

    private boolean isSharp(Item item) {
        return this.sharpList.contains(item);
    }

    private boolean isBlunt(Item item) {
        return this.bluntList.contains(item);
    }

    private boolean isPierce(Item item) {
        return this.pierceList.contains(item);
    }
}

