/*
 * Decompiled with CFR 0.152.
 */
package com.sonicjumper.enhancedvisuals.handlers;

import com.sonicjumper.enhancedvisuals.VisualManager;
import com.sonicjumper.enhancedvisuals.events.SoundMuteHandler;
import com.sonicjumper.enhancedvisuals.handlers.VisualHandler;
import com.sonicjumper.enhancedvisuals.visuals.types.VisualType;
import java.awt.Color;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;

public class ExplosionHandler
extends VisualHandler {
    public static int maxExplosionTime = 1000;
    public static float explosionTimeModifier = 20.0f;
    public static float minExplosionVolume = 0.0f;
    public static float explosionVolumeModifier = 10.0f;
    public static float maxBeepVolume = 0.5f;
    public static float maxBlur = 100.0f;
    public static float blurTimeFactor = 2.5f;
    public float dustSplatsMultiplier = 10.0f;
    public int dustMaxDuration = 1000;
    public int dustMinDuration = 500;

    public ExplosionHandler() {
        super("explosion", "");
    }

    @Override
    public void initConfig(Configuration config) {
        super.initConfig(config);
        maxExplosionTime = config.getInt("maxExplosionTime", this.name, maxExplosionTime, 0, 100000, "maximum explosion duration");
        explosionTimeModifier = config.getFloat("explosionTimeModifier", this.name, explosionTimeModifier, 0.0f, 100000.0f, "time = Math.max(maxExplosionTime, damage*explosionTimeModifier)");
        minExplosionVolume = config.getFloat("minExplosionVolume", this.name, minExplosionVolume, 0.0f, 100000.0f, "factor of all other sounds (muting effect)");
        explosionVolumeModifier = config.getFloat("explosionVolumeModifier", this.name, explosionVolumeModifier, 0.0f, 100000.0f, "volume of beep = damage/ConfigCore.explosionVolumeModifier");
        maxBeepVolume = config.getFloat("maxBeepVolume", this.name, maxBeepVolume, 0.0f, 100000.0f, "max volume of a beep");
        maxBlur = config.getFloat("maxBlur", this.name, maxBlur, 0.0f, 100000.0f, "max blur effect");
        blurTimeFactor = config.getFloat("blurTimeFactor", this.name, blurTimeFactor, 0.0f, 100000.0f, "time of blur = time of muted sounds / blurTimeFactor");
        this.dustSplatsMultiplier = config.getFloat("dustSplatsMultiplier", this.name, this.dustSplatsMultiplier, 0.0f, 10000.0f, "damage * multiplier = number of splats");
        this.dustMaxDuration = config.getInt("dustMaxDuration", this.name, this.dustMaxDuration, 1, 100000, "max duration of one particle");
        this.dustMinDuration = config.getInt("dustMinDuration", this.name, this.dustMinDuration, 1, 100000, "min duration of one particle");
    }

    @Override
    public void onExplosion(EntityPlayer player, double x, double y, double z, double distance) {
        if (distance < 5.0) {
            float damage = (float)(1.0 - distance / 5.0) * 5.0f;
            System.out.println(damage);
            VisualManager.addVisualsWithShading(VisualType.dust, (int)Math.min(40.0f, damage * this.dustSplatsMultiplier), this.dustMinDuration, this.dustMaxDuration);
            float volume = Math.max(minExplosionVolume, 1.0f - damage / explosionVolumeModifier);
            int time = (int)Math.min((float)maxExplosionTime, damage * explosionTimeModifier);
            if (!SoundMuteHandler.isMuting) {
                this.playSound(new ResourceLocation("enhancedvisuals:ringing"), null, (1.0f - volume) * maxBeepVolume);
            }
            SoundMuteHandler.startMuting(time, volume);
            VisualManager.addVisualWithShading(VisualType.blur, maxBlur, (int)((float)time / blurTimeFactor), (int)((float)time / blurTimeFactor), Color.WHITE);
        }
    }
}

