/*
 * Decompiled with CFR 0.152.
 */
package com.sonicjumper.enhancedvisuals.handlers;

import com.sonicjumper.enhancedvisuals.VisualManager;
import com.sonicjumper.enhancedvisuals.handlers.VisualHandler;
import com.sonicjumper.enhancedvisuals.visuals.types.VisualType;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.config.Configuration;

public class HeartBeatHandler
extends VisualHandler {
    public float heartBeatIntensity = 50.0f;
    public int heartBeatDuration = 5;
    public int maxHearts = 6;
    public int minHeartBeatLength = 15;
    public float heartBeatTimeFactor = 5.0f;
    public float heartBeatVolume = 1.0f;
    public int lowHealthBuffer;

    public HeartBeatHandler() {
        super("heart beat", "blur & bloody overlay");
    }

    @Override
    public void initConfig(Configuration config) {
        super.initConfig(config);
        this.heartBeatIntensity = config.getFloat("heartBeatIntensity", this.name, this.heartBeatIntensity, 0.0f, 10000.0f, "heartbeat blur intensity");
        this.heartBeatDuration = config.getInt("heartBeatDuration", this.name, this.heartBeatDuration, 0, 10000, "heartbeat blur duration");
        this.maxHearts = config.getInt("heartLevel", this.name, this.maxHearts, 0, 20, "below or equal means the heartbeat will take effect");
        this.minHeartBeatLength = config.getInt("minHeartBeatLength", this.name, this.minHeartBeatLength, 0, 100000, "time between heartbeats = player.health * heartBeatHeartFactor + minHeartBeatLength");
        this.heartBeatTimeFactor = config.getFloat("heartBeatTimeFactor", this.name, this.heartBeatTimeFactor, 0.0f, 100000.0f, "time between heartbeats = player.health * heartBeatHeartFactor + minHeartBeatLength");
        this.heartBeatVolume = config.getFloat("heartBeatVolume", this.name, this.heartBeatVolume, 0.0f, 1.0f, "How loud the heart beat sounds should be");
    }

    @Override
    public void onTick(@Nullable EntityPlayer player) {
        if (player != null && player.func_110143_aJ() <= (float)this.maxHearts) {
            if (this.lowHealthBuffer <= 0) {
                float f1 = (7.0f - player.func_110143_aJ()) * 0.2f;
                this.lowHealthBuffer = (int)(player.func_110143_aJ() * this.heartBeatTimeFactor + (float)this.minHeartBeatLength);
                VisualManager.addVisualWithShading(VisualType.lowhealth, Math.min(0.7f, f1), this.lowHealthBuffer, this.lowHealthBuffer, Color.WHITE);
                VisualManager.addVisualWithShading(VisualType.blur, Math.min(0.7f, f1) * this.heartBeatIntensity, this.heartBeatDuration, this.heartBeatDuration, Color.WHITE);
                this.playSound(new ResourceLocation("enhancedvisuals:heartbeatOut"), new BlockPos((Entity)player), this.heartBeatVolume);
            } else if (this.lowHealthBuffer == 5) {
                this.playSound(new ResourceLocation("enhancedvisuals:heartbeatIn"), new BlockPos((Entity)player), this.heartBeatVolume);
                VisualManager.addVisualWithShading(VisualType.blur, this.heartBeatIntensity, this.heartBeatDuration, this.heartBeatDuration, Color.WHITE);
                --this.lowHealthBuffer;
            } else {
                --this.lowHealthBuffer;
            }
        }
    }
}

