/*
 * Decompiled with CFR 0.152.
 */
package com.sonicjumper.enhancedvisuals.handlers;

import com.sonicjumper.enhancedvisuals.VisualManager;
import com.sonicjumper.enhancedvisuals.handlers.VisualHandler;
import com.sonicjumper.enhancedvisuals.visuals.VisualPersistent;
import com.sonicjumper.enhancedvisuals.visuals.types.VisualType;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.config.Configuration;

public class SaturationHandler
extends VisualHandler {
    public float defaultSaturation = 1.0f;
    public float minSaturation = 0.0f;
    public float fadeFactor = 5.0E-4f;
    public int maxFoodLevelEffected = 8;
    public int minFoodLevelEffected = 2;

    public SaturationHandler() {
        super("saturation", "saturation depending on hunger");
    }

    @Override
    public void initConfig(Configuration config) {
        super.initConfig(config);
        this.defaultSaturation = config.getFloat("defaultSaturation", this.name, this.defaultSaturation, 0.0f, 10000.0f, "the default/max saturation");
        this.minSaturation = config.getFloat("minSaturation", this.name, this.minSaturation, 0.0f, 10000.0f, "lowest saturation");
        this.fadeFactor = config.getFloat("fadeFactor", this.name, this.fadeFactor, 0.0f, 10000.0f, "saturation += fadeFactor per Tick");
        this.maxFoodLevelEffected = config.getInt("maxFoodLevelEffected", this.name, this.maxFoodLevelEffected, 0, 20, "the maximum point saturation is effected");
        this.minFoodLevelEffected = config.getInt("minFoodLevelEffected", this.name, this.minFoodLevelEffected, 0, 20, "the minimum point saturation is effected");
    }

    @Override
    public void onTick(@Nullable EntityPlayer player) {
        VisualPersistent visual = VisualManager.getPersitentVisual(VisualType.desaturate);
        if (visual != null) {
            float aimedSaturation = this.defaultSaturation;
            if (player != null && player.func_71024_bL().func_75116_a() <= this.maxFoodLevelEffected) {
                float leftFoodInSpan = player.func_71024_bL().func_75116_a() - this.minFoodLevelEffected;
                float spanLength = this.maxFoodLevelEffected - this.minFoodLevelEffected;
                aimedSaturation = Math.max(this.minSaturation, leftFoodInSpan / spanLength * this.defaultSaturation);
            }
            if (visual.getIntensity() < aimedSaturation) {
                visual.setIntensity(Math.min(visual.getIntensity() + this.fadeFactor, aimedSaturation));
            } else if (visual.getIntensity() > aimedSaturation) {
                visual.setIntensity(Math.max(visual.getIntensity() - this.fadeFactor, aimedSaturation));
            }
        }
    }
}

