/*
 * Decompiled with CFR 0.152.
 */
package com.sonicjumper.enhancedvisuals.handlers;

import com.sonicjumper.enhancedvisuals.VisualManager;
import com.sonicjumper.enhancedvisuals.handlers.VisualHandler;
import com.sonicjumper.enhancedvisuals.visuals.VisualPersistent;
import com.sonicjumper.enhancedvisuals.visuals.types.VisualType;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.config.Configuration;

public class SlenderHandler
extends VisualHandler {
    public float defaultIntensity = 0.0f;
    public float slenderDistanceFactor = 0.25f;
    public float maxIntensity = 0.3f;

    public SlenderHandler() {
        super("slender", "slenderman effect if you are near an enderman");
    }

    @Override
    public void initConfig(Configuration config) {
        super.initConfig(config);
        this.defaultIntensity = config.getFloat("defaultIntensity", this.name, this.defaultIntensity, 0.0f, 1.0f, "the default intensity");
        this.slenderDistanceFactor = config.getFloat("slenderDistanceFactor", this.name, this.slenderDistanceFactor, 0.0f, 10000.0f, "intensity = distance * slenderDistanceFactor");
        this.maxIntensity = config.getFloat("maxIntensity", this.name, this.maxIntensity, 0.0f, 1.0f, "maximum intensity");
    }

    @Override
    public void onTick(@Nullable EntityPlayer player) {
        VisualPersistent visual = VisualManager.getPersitentVisual(VisualType.slender);
        if (visual != null && player != null) {
            boolean angryNearby = false;
            float modifier = 0.0f;
            double d0 = player.field_70165_t;
            double d1 = player.field_70163_u;
            double d2 = player.field_70161_v;
            AxisAlignedBB box = player.func_174813_aQ();
            EntityEnderman mob = (EntityEnderman)player.field_70170_p.func_72857_a(EntityEnderman.class, box = box.func_72314_b(16.0, 16.0, 16.0), (Entity)player);
            if (mob != null) {
                angryNearby = true;
                float distModifier = (float)(1.0 / Math.pow(Math.sqrt(Math.pow(d0 - mob.field_70165_t, 2.0) + Math.pow(d1 - mob.field_70163_u, 2.0) + Math.pow(d2 - mob.field_70161_v, 2.0)) / 3.0, 2.0));
                if (distModifier > modifier && (modifier = distModifier) > 3.5f) {
                    modifier = 3.5f;
                }
            }
            if (angryNearby) {
                visual.setIntensity(Math.max(this.defaultIntensity, Math.min(this.maxIntensity, this.slenderDistanceFactor * modifier)));
            } else {
                visual.setIntensity(this.defaultIntensity);
            }
        }
    }
}

