/*
 * Decompiled with CFR 0.152.
 */
package com.sonicjumper.enhancedvisuals.visuals;

import com.sonicjumper.enhancedvisuals.visuals.VisualProperties;
import com.sonicjumper.enhancedvisuals.visuals.types.VisualType;
import java.awt.Color;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayer;

public abstract class Visual {
    public static Random rand = new Random();
    public VisualType type;
    protected float intensity;
    protected Color color;
    public int variant;
    public VisualProperties properties;

    public Visual(VisualType type, float intensity) {
        this(type, intensity, Color.WHITE);
    }

    public Visual(VisualType type, float intensity, Color color) {
        this.type = type;
        this.intensity = intensity;
        this.color = color;
        int n = this.variant = type.getVariantAmount() > 0 ? rand.nextInt(type.getVariantAmount()) : 0;
        if (this.isRandomized()) {
            this.properties = this.randomize();
        }
    }

    public void onTick(@Nullable EntityPlayer player) {
    }

    public float getIntensity() {
        return this.intensity;
    }

    public boolean supportsColor() {
        return this.type.supportsColor();
    }

    public Color getColor() {
        return this.color;
    }

    public abstract boolean hasFinished();

    public abstract boolean isRandomized();

    public VisualProperties randomize() {
        int size = rand.nextInt(this.type.getSize());
        VisualProperties properties = new VisualProperties(0, 0, size, size, rand.nextFloat() * 360.0f);
        ScaledResolution scaledRes = new ScaledResolution(Minecraft.func_71410_x());
        properties.posX = Visual.generateOffset(scaledRes.func_78326_a(), properties.width);
        properties.posY = Visual.generateOffset(scaledRes.func_78328_b(), properties.height);
        return properties;
    }

    public static int generateOffset(int dimensionLength, int spacingBuffer) {
        float halfDimLength = (float)dimensionLength / 2.0f;
        float multiplier = (float)(1.0 - Math.pow(rand.nextDouble(), 2.0));
        float textureCenterPosition = rand.nextInt(2) == 0 ? halfDimLength + halfDimLength * multiplier : halfDimLength - halfDimLength * multiplier;
        return (int)(textureCenterPosition - (float)spacingBuffer / 2.0f);
    }
}

