/*
 * Decompiled with CFR 0.152.
 */
package com.sonicjumper.enhancedvisuals.visuals;

import com.sonicjumper.enhancedvisuals.visuals.Visual;
import com.sonicjumper.enhancedvisuals.visuals.types.VisualType;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;

public class VisualPersistent
extends Visual {
    public ArrayList<Visual> subVisuals = new ArrayList();
    private final float defaultIntensity;

    public VisualPersistent(VisualType type, float intensity) {
        super(type, intensity);
        this.defaultIntensity = intensity;
    }

    @Override
    public boolean hasFinished() {
        return false;
    }

    @Override
    public void onTick(@Nullable EntityPlayer player) {
        int i = 0;
        while (i < this.subVisuals.size()) {
            if (this.subVisuals.get(i).hasFinished()) {
                this.subVisuals.remove(i);
                continue;
            }
            this.subVisuals.get(i).onTick(player);
            ++i;
        }
    }

    public void addVisual(Visual visual) {
        this.subVisuals.add(visual);
    }

    @Override
    public float getIntensity() {
        float intensity = this.intensity;
        for (int i = 0; i < this.subVisuals.size(); ++i) {
            intensity += this.subVisuals.get(i).getIntensity();
        }
        return intensity;
    }

    public void setIntensity(float intensity) {
        this.intensity = intensity;
    }

    @Override
    public boolean isRandomized() {
        return false;
    }

    public void reset() {
        this.subVisuals.clear();
        this.intensity = this.defaultIntensity;
    }
}

