/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.api.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Color3b;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.resources.IResourceManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.config.CreativeConfig;
import team.creative.creativecore.common.config.ICreativeConfig;
import team.creative.enhancedvisuals.api.Visual;
import team.creative.enhancedvisuals.api.VisualCategory;

public abstract class VisualType
implements ICreativeConfig {
    private static List<VisualType> types = new ArrayList<VisualType>();
    @CreativeConfig
    public boolean enabled;
    @CreativeConfig
    @CreativeConfig.FloatRange(max=1.0f, min=0.0f)
    public float opacity = 1.0f;
    public final String name;
    public final VisualCategory cat;

    public static Collection<VisualType> getTypes() {
        return types;
    }

    public VisualType(String name, VisualCategory cat) {
        this.name = name;
        this.cat = cat;
        types.add(this);
    }

    public boolean isAffectedByWater() {
        return this.cat.isAffectedByWater();
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract void loadResources(IResourceManager var1);

    @OnlyIn(value=Dist.CLIENT)
    public abstract void render(Visual var1, TextureManager var2, int var3, int var4, float var5);

    public void configured() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getVariantAmount() {
        return 1;
    }

    public boolean supportsColor() {
        return false;
    }

    public Color3b getColor() {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void resize(Framebuffer buffer) {
    }

    public boolean isVisible(Visual visual) {
        return visual.opacity > 0.0f;
    }

    public int getWidth(int screenWidth) {
        return screenWidth;
    }

    public int getHeight(int screenHeight) {
        return screenHeight;
    }
}

