/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.api.type;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.config.CreativeConfig;
import team.creative.enhancedvisuals.EnhancedVisuals;
import team.creative.enhancedvisuals.api.Visual;
import team.creative.enhancedvisuals.api.VisualCategory;
import team.creative.enhancedvisuals.api.type.VisualType;

public abstract class VisualTypeTexture
extends VisualType {
    @CreativeConfig
    public float scale = 1.0f;
    @CreativeConfig
    public int animationSpeed;
    public String domain;
    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation[] resources;
    @OnlyIn(value=Dist.CLIENT)
    public Dimension dimension;

    public VisualTypeTexture(VisualCategory category, String name, String domain, int animationSpeed) {
        super(name, category);
        this.domain = domain;
        this.animationSpeed = animationSpeed;
    }

    public VisualTypeTexture(VisualCategory category, String name, String domain, int animationSpeed, float scale) {
        super(name, category);
        this.domain = domain;
        this.animationSpeed = animationSpeed;
        this.scale = scale;
    }

    public VisualTypeTexture(VisualCategory category, String name, int animationSpeed, float scale) {
        this(category, name, null, animationSpeed, scale);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void loadResources(IResourceManager manager) {
        String baseLocation = "visuals/" + this.cat.name() + "/" + this.name + "/" + this.name;
        ArrayList<ResourceLocation> locations = new ArrayList<ResourceLocation>();
        int i = 0;
        ResourceLocation location = null;
        IResource resource = null;
        try {
            while ((resource = manager.func_199002_a(location = new ResourceLocation(this.domain == null ? "enhancedvisuals" : this.domain, baseLocation + i + ".png"))) != null) {
                if (i == 0) {
                    BufferedImage image = ImageIO.read(resource.func_199027_b());
                    this.dimension = new Dimension(image.getWidth(), image.getHeight());
                }
                locations.add(location);
                ++i;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.resources = locations.toArray(new ResourceLocation[0]);
        if (this.resources.length == 0) {
            EnhancedVisuals.LOGGER.warn("Could not find any resources for '" + this.name + "'!");
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean supportsColor() {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getVariantAmount() {
        return this.resources.length;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getResource(Visual visual) {
        if (this.animationSpeed > 0) {
            long time = Math.abs(System.nanoTime() / 3000000L / (long)this.animationSpeed);
            return this.resources[(int)(time % (long)this.resources.length)];
        }
        return this.resources[visual.variant];
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(Visual visual, TextureManager manager, int screenWidth, int screenHeight, float partialTicks) {
        manager.func_110577_a(this.getResource(visual));
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder renderer = tessellator.func_178180_c();
        float red = visual.color != null ? (float)visual.color.getRed() / 255.0f : 1.0f;
        float green = visual.color != null ? (float)visual.color.getGreen() / 255.0f : 1.0f;
        float blue = visual.color != null ? (float)visual.color.getBlue() / 255.0f : 1.0f;
        double z = -90.0;
        int width = visual.getWidth(screenWidth);
        int height = visual.getHeight(screenHeight);
        renderer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        renderer.func_181662_b(0.0, (double)height, z).func_187315_a(0.0, 1.0).func_181666_a(red, green, blue, visual.opacity).func_181675_d();
        renderer.func_181662_b((double)width, (double)height, z).func_187315_a(1.0, 1.0).func_181666_a(red, green, blue, visual.opacity).func_181675_d();
        renderer.func_181662_b((double)width, 0.0, z).func_187315_a(1.0, 0.0).func_181666_a(red, green, blue, visual.opacity).func_181675_d();
        renderer.func_181662_b(0.0, 0.0, z).func_187315_a(0.0, 0.0).func_181666_a(red, green, blue, visual.opacity).func_181675_d();
        tessellator.func_78381_a();
    }

    @Override
    public int getWidth(int screenWidth) {
        return (int)((float)this.dimension.width * this.scale);
    }

    @Override
    public int getHeight(int screenHeight) {
        return (int)((float)this.dimension.height * this.scale);
    }
}

