/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.DeathScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import team.creative.enhancedvisuals.EnhancedVisuals;
import team.creative.enhancedvisuals.api.Visual;
import team.creative.enhancedvisuals.api.VisualCategory;
import team.creative.enhancedvisuals.api.type.VisualType;
import team.creative.enhancedvisuals.client.EVClient;
import team.creative.enhancedvisuals.client.VisualManager;

public class EVRenderer {
    private static Minecraft mc = Minecraft.func_71410_x();
    private static String lastRenderedMessage;
    private static int framebufferWidth;
    private static int framebufferHeight;
    public static boolean reloadResources;

    @SubscribeEvent
    public static void render(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END && EVClient.shouldRender()) {
            if (reloadResources) {
                for (VisualType type : VisualType.getTypes()) {
                    type.loadResources(mc.func_195551_G());
                }
                reloadResources = false;
            }
            if (!(EVRenderer.mc.field_71462_r instanceof DeathScreen)) {
                if (EVRenderer.mc.func_147110_a().field_147621_c != framebufferWidth || EVRenderer.mc.func_147110_a().field_147618_d != framebufferHeight) {
                    for (VisualType type : VisualType.getTypes()) {
                        type.resize(mc.func_147110_a());
                    }
                    framebufferWidth = EVRenderer.mc.func_147110_a().field_147621_c;
                    framebufferHeight = EVRenderer.mc.func_147110_a().field_147618_d;
                }
                int screenWidth = EVRenderer.mc.field_195558_d.func_198107_o();
                int screenHeight = EVRenderer.mc.field_195558_d.func_198087_p();
                GlStateManager.pushMatrix();
                TextureManager manager = mc.func_110434_K();
                float partialTicks = event.renderTickTime;
                RenderHelper.func_74519_b();
                GlStateManager.disableLighting();
                GlStateManager.clear((int)256, (boolean)false);
                GlStateManager.matrixMode((int)5889);
                GlStateManager.loadIdentity();
                GlStateManager.ortho((double)0.0, (double)EVRenderer.mc.field_195558_d.func_198107_o(), (double)EVRenderer.mc.field_195558_d.func_198087_p(), (double)0.0, (double)1000.0, (double)3000.0);
                GlStateManager.matrixMode((int)5888);
                GlStateManager.loadIdentity();
                GlStateManager.translatef((float)0.0f, (float)0.0f, (float)-2000.0f);
                GlStateManager.enableBlend();
                GlStateManager.disableDepthTest();
                GlStateManager.depthMask((boolean)false);
                GlStateManager.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.disableAlphaTest();
                GlStateManager.enableBlend();
                EVRenderer.renderVisuals(VisualManager.visuals(VisualCategory.overlay), manager, screenWidth, screenHeight, partialTicks);
                EVRenderer.renderVisuals(VisualManager.visuals(VisualCategory.particle), manager, screenWidth, screenHeight, partialTicks);
                GlStateManager.matrixMode((int)5890);
                GlStateManager.pushMatrix();
                GlStateManager.loadIdentity();
                EVRenderer.renderVisuals(VisualManager.visuals(VisualCategory.shader), manager, screenWidth, screenHeight, partialTicks);
                GlStateManager.popMatrix();
                GlStateManager.depthMask((boolean)true);
                GlStateManager.enableDepthTest();
                GlStateManager.enableAlphaTest();
                GlStateManager.disableLighting();
                mc.func_147110_a().func_147610_a(false);
                GlStateManager.matrixMode((int)5888);
                GlStateManager.popMatrix();
            } else if (EnhancedVisuals.MESSAGES.enabled) {
                if (lastRenderedMessage == null) {
                    lastRenderedMessage = EnhancedVisuals.MESSAGES.pickRandomDeathMessage();
                }
                if (lastRenderedMessage != null) {
                    EVRenderer.mc.field_71466_p.func_211126_b("\"" + lastRenderedMessage + "\"", (float)(EVRenderer.mc.field_71462_r.width / 2 - EVRenderer.mc.field_71466_p.func_78256_a(lastRenderedMessage) / 2), 114.0f, 0xFFFFFF);
                }
            }
        }
    }

    private static void renderVisuals(Collection<Visual> visuals, TextureManager manager, int screenWidth, int screenHeight, float partialTicks) {
        if (visuals == null || visuals.isEmpty()) {
            return;
        }
        try {
            for (Visual visual : visuals) {
                if (!visual.isVisible()) continue;
                GlStateManager.pushMatrix();
                visual.render(manager, screenWidth, screenHeight, partialTicks);
                GlStateManager.popMatrix();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        reloadResources = false;
    }
}

