/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.client.sound;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ChannelManager;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundEngine;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import team.creative.creativecore.common.config.premade.curve.DecimalCurve;

@OnlyIn(value=Dist.CLIENT)
public class SoundMuteHandler {
    private static Minecraft mc = Minecraft.func_71410_x();
    public static boolean isMuting = false;
    public static SoundEngine engine;
    public static SoundHandler handler;
    public static ArrayList<String> ignoredSounds;
    public static DecimalCurve muteGraph;
    public static int timeTick;
    private static Field playingSoundsChannelField;

    public static void tick() {
        if (isMuting) {
            double factor = muteGraph.valueAt((double)timeTick);
            if (factor <= 0.0) {
                SoundMuteHandler.endMuting();
            } else {
                SoundMuteHandler.setMuteVolume((float)(1.0 - factor));
                ++timeTick;
            }
        }
    }

    public static float getClampedVolume(ISound soundIn) {
        return SoundMuteHandler.getClampedVolume(soundIn, isMuting ? (float)(1.0 - muteGraph.valueAt((double)timeTick)) : 1.0f);
    }

    public static Map<ISound, ChannelManager.Entry> getSounds() {
        try {
            return (Map)playingSoundsChannelField.get(engine);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void setMuteVolume(float muteVolume) {
        if (!isMuting) {
            return;
        }
        SoundMuteHandler.getSounds().forEach((p_217926_1_, p_217926_2_) -> {
            float f = SoundMuteHandler.getClampedVolume(p_217926_1_, muteVolume);
            p_217926_2_.func_217888_a(p_217923_1_ -> p_217923_1_.func_216430_b(f));
        });
    }

    private static float getClampedVolume(ISound soundIn, float muteVolume) {
        return MathHelper.func_76131_a((float)(soundIn.func_147653_e() * SoundMuteHandler.getVolume(soundIn.func_184365_d())), (float)0.0f, (float)1.0f) * muteVolume;
    }

    private static float getVolume(SoundCategory category) {
        return category != null && category != SoundCategory.MASTER ? SoundMuteHandler.mc.field_71474_y.func_186711_a(category) : 1.0f;
    }

    public static boolean startMuting(DecimalCurve muteGraph) {
        if (engine == null) {
            handler = Minecraft.func_71410_x().func_147118_V();
            engine = (SoundEngine)ObfuscationReflectionHelper.getPrivateValue(SoundHandler.class, (Object)handler, (String)"sndManager");
        }
        if (isMuting && SoundMuteHandler.muteGraph.valueAt((double)timeTick) > muteGraph.valueAt(0.0)) {
            SoundMuteHandler.muteGraph = muteGraph;
            timeTick = 0;
            SoundMuteHandler.tick();
            return true;
        }
        if (!isMuting) {
            SoundMuteHandler.muteGraph = muteGraph;
            timeTick = 0;
            ignoredSounds = new ArrayList();
            isMuting = true;
            SoundMuteHandler.tick();
            return true;
        }
        return false;
    }

    public static void endMuting() {
        SoundMuteHandler.setMuteVolume(1.0f);
        isMuting = false;
        ignoredSounds = null;
    }

    static {
        timeTick = 0;
        playingSoundsChannelField = ObfuscationReflectionHelper.findField(SoundEngine.class, (String)"field_217942_m");
    }
}

