/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.common.handler;

import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import team.creative.creativecore.common.config.CreativeConfig;
import team.creative.creativecore.common.config.premade.IntMinMax;
import team.creative.creativecore.common.config.premade.curve.Curve;
import team.creative.creativecore.common.config.premade.curve.DecimalCurve;
import team.creative.enhancedvisuals.api.VisualHandler;
import team.creative.enhancedvisuals.api.type.VisualType;
import team.creative.enhancedvisuals.api.type.VisualTypeParticle;
import team.creative.enhancedvisuals.client.VisualManager;
import team.creative.enhancedvisuals.common.packet.DamagePacket;

public class DamageHandler
extends VisualHandler {
    public static final ArrayList<Item> sharpList = new ArrayList();
    public static final ArrayList<Item> bluntList = new ArrayList();
    public static final ArrayList<Item> pierceList = new ArrayList();
    public VisualType splatter = new VisualTypeParticle("splatter", 1.0f);
    public VisualType impact = new VisualTypeParticle("impact", 1.0f);
    public VisualType slash = new VisualTypeParticle("slash", 1.0f);
    public VisualType pierce = new VisualTypeParticle("pierce", 1.0f);
    @CreativeConfig
    public IntMinMax bloodDuration = new IntMinMax(500, 1500);
    public static VisualType fire;
    @CreativeConfig
    public int fireSplashes = 1;
    @CreativeConfig
    public IntMinMax fireDuration = new IntMinMax(100, 1000);
    @CreativeConfig
    public int drownSplashes = 4;
    @CreativeConfig
    public IntMinMax drownDuration = new IntMinMax(10, 15);
    public VisualType waterDrown = new VisualTypeParticle("water", 1.0f);
    public static Color bloodColor;

    public void playerDamaged(PlayerEntity player, DamagePacket packet) {
        if (packet.source == EnhancedDamageSource.ATTACKER) {
            if (packet.attackerClass.contains("arrow")) {
                DamageHandler.createVisualFromDamageAndDistance(this.pierce, packet.damage, player, this.bloodDuration);
            }
            if (packet.stack != null) {
                if (DamageHandler.isSharp(packet.stack)) {
                    DamageHandler.createVisualFromDamageAndDistance(this.slash, packet.damage, player, this.bloodDuration);
                } else if (DamageHandler.isBlunt(packet.stack)) {
                    DamageHandler.createVisualFromDamageAndDistance(this.impact, packet.damage, player, this.bloodDuration);
                } else if (DamageHandler.isPierce(packet.stack)) {
                    DamageHandler.createVisualFromDamageAndDistance(this.pierce, packet.damage, player, this.bloodDuration);
                } else {
                    DamageHandler.createVisualFromDamageAndDistance(this.splatter, packet.damage, player, this.bloodDuration);
                }
            } else if (packet.attackerClass.contains("zombie") || packet.attackerClass.contains("skeleton") || packet.attackerClass.contains("ocelot")) {
                DamageHandler.createVisualFromDamageAndDistance(this.slash, packet.damage, player, this.bloodDuration);
            } else if (packet.attackerClass.contains("golem") || packet.attackerClass.contains("player")) {
                DamageHandler.createVisualFromDamageAndDistance(this.impact, packet.damage, player, this.bloodDuration);
            } else if (packet.attackerClass.contains("wolf") || packet.attackerClass.contains("spider")) {
                DamageHandler.createVisualFromDamageAndDistance(this.pierce, packet.damage, player, this.bloodDuration);
            }
        } else if (packet.source == EnhancedDamageSource.CACTUS) {
            DamageHandler.createVisualFromDamageAndDistance(this.pierce, packet.damage, player, this.bloodDuration);
        } else if (packet.source == EnhancedDamageSource.FALL) {
            DamageHandler.createVisualFromDamageAndDistance(this.impact, packet.damage, player, this.bloodDuration);
        } else if (packet.source == EnhancedDamageSource.DROWN) {
            VisualManager.addParticlesFadeOut(this.waterDrown, this.drownSplashes, this.drownDuration, true);
        } else if (packet.source == EnhancedDamageSource.FIRE) {
            VisualManager.addParticlesFadeOut(fire, this.fireSplashes, this.fireDuration, true);
        }
    }

    public static void createVisualFromDamageAndDistance(VisualType type, float damage, PlayerEntity player, IntMinMax duration) {
        if (damage <= 0.0f) {
            return;
        }
        float rate = 0.0f;
        float health = player.func_110143_aJ() - damage;
        if (health > 12.0f) {
            rate = 1.0f;
        }
        if (health <= 12.0f && health > 8.0f) {
            rate = 1.5f;
        }
        if (health <= 8.0f && health > 4.0f) {
            rate = 2.0f;
        }
        if (health <= 4.0f && health > 0.0f) {
            rate = 2.5f;
        }
        if (health <= 0.0f) {
            rate = 3.0f;
        }
        VisualManager.addParticlesFadeOut(type, (int)(damage * rate), (Curve)new DecimalCurve(0.0, 1.0, (double)duration.next(VisualManager.rand), 0.0), true, bloodColor);
    }

    private static boolean isSharp(ItemStack item) {
        return sharpList.contains(item.func_77973_b());
    }

    private static boolean isBlunt(ItemStack item) {
        return bluntList.contains(item.func_77973_b());
    }

    private static boolean isPierce(ItemStack item) {
        return pierceList.contains(item.func_77973_b());
    }

    static {
        sharpList.add(Items.field_151040_l);
        sharpList.add(Items.field_151041_m);
        sharpList.add(Items.field_151052_q);
        sharpList.add(Items.field_151048_u);
        sharpList.add(Items.field_151010_B);
        sharpList.add(Items.field_151036_c);
        sharpList.add(Items.field_151053_p);
        sharpList.add(Items.field_151049_t);
        sharpList.add(Items.field_151056_x);
        sharpList.add(Items.field_151006_E);
        bluntList.add(Items.field_151035_b);
        bluntList.add(Items.field_151039_o);
        bluntList.add(Items.field_151050_s);
        bluntList.add(Items.field_151046_w);
        bluntList.add(Items.field_151005_D);
        bluntList.add(Items.field_151037_a);
        bluntList.add(Items.field_151038_n);
        bluntList.add(Items.field_151051_r);
        bluntList.add(Items.field_151047_v);
        bluntList.add(Items.field_151011_C);
        pierceList.add(Items.field_151019_K);
        pierceList.add(Items.field_151017_I);
        pierceList.add(Items.field_151018_J);
        pierceList.add(Items.field_151012_L);
        pierceList.add(Items.field_151013_M);
        pierceList.add(Items.field_151032_g);
        fire = new VisualTypeParticle("fire", 1.0f);
        bloodColor = new Color(0.3f, 0.01f, 0.01f, 0.7f);
    }

    public static enum EnhancedDamageSource {
        ATTACKER,
        CACTUS,
        FALL,
        DROWN,
        FIRE,
        UNKOWN;

    }
}

