/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.common.handler;

import javax.annotation.Nullable;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import team.creative.creativecore.common.config.CreativeConfig;
import team.creative.creativecore.common.config.premade.curve.Curve;
import team.creative.creativecore.common.config.premade.curve.DecimalCurve;
import team.creative.enhancedvisuals.api.Visual;
import team.creative.enhancedvisuals.api.VisualHandler;
import team.creative.enhancedvisuals.api.event.SelectEndermanEvent;
import team.creative.enhancedvisuals.api.type.VisualType;
import team.creative.enhancedvisuals.api.type.VisualTypeOverlay;
import team.creative.enhancedvisuals.client.VisualManager;

public class SlenderHandler
extends VisualHandler {
    @CreativeConfig
    public double defaultIntensity = 0.0;
    @CreativeConfig
    public double maxIntensity = 0.3;
    @CreativeConfig
    public double distanceFactor = 0.25;
    @CreativeConfig
    public VisualType slender = new VisualTypeOverlay("slender", 50);
    public Visual slenderVisual;

    @Override
    public void tick(@Nullable PlayerEntity player) {
        if (this.slenderVisual == null) {
            this.slenderVisual = new Visual(this.slender, (Curve)new DecimalCurve(0.0, 1.0, 1.0, 1.0), 0);
            VisualManager.add(this.slenderVisual);
        }
        float intensity = (float)this.defaultIntensity;
        if (player != null) {
            EndermanEntity mob;
            float modifier = 0.0f;
            double d0 = player.field_70165_t;
            double d1 = player.field_70163_u;
            double d2 = player.field_70161_v;
            AxisAlignedBB box = player.func_174813_aQ();
            box = box.func_72314_b(16.0, 16.0, 16.0);
            SelectEndermanEvent event = new SelectEndermanEvent(new EntityPredicate());
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (!event.isCanceled() && (mob = (EndermanEntity)player.field_70170_p.func_217360_a(EndermanEntity.class, event.predicate, (LivingEntity)player, d0, d1, d2, box)) != null) {
                float distModifier = (float)(1.0 / Math.pow(Math.sqrt(Math.pow(d0 - mob.field_70165_t, 2.0) + Math.pow(d1 - mob.field_70163_u, 2.0) + Math.pow(d2 - mob.field_70161_v, 2.0)) / 3.0, 2.0));
                if (distModifier > modifier && (modifier = distModifier) > 3.5f) {
                    modifier = 3.5f;
                }
                this.slenderVisual.opacity = (float)Math.max(this.defaultIntensity, Math.min(this.maxIntensity, this.distanceFactor * (double)modifier));
            }
        }
        this.slenderVisual.opacity = intensity;
    }
}

