/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.common.packet;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import team.creative.creativecore.common.network.CanBeNull;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.enhancedvisuals.common.handler.DamageHandler;
import team.creative.enhancedvisuals.common.handler.VisualHandlers;

public class DamagePacket
extends CreativePacket {
    @CanBeNull
    public String attackerClass;
    @CanBeNull
    public ItemStack stack;
    public float damage;
    public float distance;
    public DamageHandler.EnhancedDamageSource source;

    public DamagePacket(LivingDamageEvent event) {
        this.damage = event.getAmount();
        Entity attacker = event.getSource().func_76364_f();
        if (attacker instanceof LivingEntity || attacker instanceof ArrowEntity) {
            this.attackerClass = attacker.getClass().getName().toLowerCase();
            this.source = DamageHandler.EnhancedDamageSource.ATTACKER;
            if (attacker instanceof LivingEntity && ((LivingEntity)attacker).func_184614_ca() != null) {
                this.stack = ((LivingEntity)attacker).func_184614_ca();
            }
        } else {
            this.source = event.getSource() == DamageSource.field_76367_g ? DamageHandler.EnhancedDamageSource.CACTUS : (event.getSource() == DamageSource.field_76379_h || event.getSource() == DamageSource.field_82729_p ? DamageHandler.EnhancedDamageSource.FALL : (event.getSource().equals(DamageSource.field_76369_e) ? DamageHandler.EnhancedDamageSource.DROWN : (event.getSource().func_76347_k() || event.getSource() == DamageSource.field_76370_b ? DamageHandler.EnhancedDamageSource.FIRE : DamageHandler.EnhancedDamageSource.UNKOWN)));
        }
    }

    public DamagePacket() {
    }

    public void executeClient(PlayerEntity player) {
        if (VisualHandlers.DAMAGE.isEnabled(player)) {
            VisualHandlers.DAMAGE.playerDamaged(player, this);
        }
    }

    public void executeServer(PlayerEntity player) {
    }
}

