/*
 * Decompiled with CFR 0.152.
 */
package zathrox.explorercraft.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import zathrox.explorercraft.init.BlockReg;
import zathrox.explorercraft.init.ItemReg;

public class BlockRiceBase
extends Block {
    public BlockRiceBase() {
        super(Material.field_151586_h);
        this.func_149672_a(SoundType.field_185848_a);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos unusued) {
        if (world.func_180495_p(pos.func_177984_a()).func_177230_c() != BlockReg.RICE_TOP || !this.canStay(world, pos)) {
            world.func_175656_a(pos, Blocks.field_150355_j.func_176223_P());
            this.func_176226_b(world, pos, state, 0);
        }
    }

    public boolean canStay(World world, BlockPos pos) {
        BlockPos posBelow = pos.func_177977_b();
        Block blockBelow = world.func_180495_p(posBelow).func_177230_c();
        if (blockBelow != Blocks.field_150349_c && blockBelow != Blocks.field_150346_d && blockBelow != Blocks.field_150354_m) {
            return false;
        }
        for (EnumFacing facingCheck : EnumFacing.Plane.HORIZONTAL) {
            boolean rice;
            BlockPos posCheck = pos.func_177972_a(facingCheck);
            IBlockState stateCheck = world.func_180495_p(posCheck);
            Block blockCheck = stateCheck.func_177230_c();
            boolean sideSolid = stateCheck.isSideSolid((IBlockAccess)world, posCheck, facingCheck.func_176734_d());
            boolean validWater = (blockCheck == Blocks.field_150355_j || blockCheck == Blocks.field_150358_i) && (Integer)stateCheck.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0 && Blocks.field_150355_j.func_176197_a(world, posCheck, null, Vec3d.field_186680_a).equals((Object)Vec3d.field_186680_a);
            boolean bl = rice = blockCheck == BlockReg.RICE_BASE;
            if (sideSolid || validWater || rice) continue;
            return false;
        }
        return true;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return world.func_180501_a(pos, Blocks.field_150355_j.func_176223_P(), world.field_72995_K ? 11 : 3);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ItemReg.RICE_STRAW;
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockLiquid.field_176367_b});
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(meta));
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        BlockPos beside = pos.func_177972_a(face);
        Block blockBeside = world.func_180495_p(beside).func_177230_c();
        return blockBeside == Blocks.field_150355_j || blockBeside == Blocks.field_150358_i;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT_MIPPED || layer == BlockRenderLayer.TRANSLUCENT;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return field_185506_k;
    }
}

