/*
 * Decompiled with CFR 0.152.
 */
package zathrox.explorercraft.blocks.decor;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockModWall
extends Block {
    public static final String SUFFIX = "wall";
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final AxisAlignedBB[] AABB_BY_INDEX = new AxisAlignedBB[]{new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75), new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.25, 0.75, 1.0, 0.75), new AxisAlignedBB(0.0, 0.0, 0.25, 0.75, 1.0, 1.0), new AxisAlignedBB(0.25, 0.0, 0.0, 0.75, 1.0, 0.75), new AxisAlignedBB(0.3125, 0.0, 0.0, 0.6875, 0.875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.75, 1.0, 0.75), new AxisAlignedBB(0.0, 0.0, 0.0, 0.75, 1.0, 1.0), new AxisAlignedBB(0.25, 0.0, 0.25, 1.0, 1.0, 0.75), new AxisAlignedBB(0.25, 0.0, 0.25, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.3125, 1.0, 0.875, 0.6875), new AxisAlignedBB(0.0, 0.0, 0.25, 1.0, 1.0, 1.0), new AxisAlignedBB(0.25, 0.0, 0.0, 1.0, 1.0, 0.75), new AxisAlignedBB(0.25, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.75), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)};
    public static final AxisAlignedBB[] CLIP_AABB_BY_INDEX = new AxisAlignedBB[]{AABB_BY_INDEX[0].func_186666_e(1.5), AABB_BY_INDEX[1].func_186666_e(1.5), AABB_BY_INDEX[2].func_186666_e(1.5), AABB_BY_INDEX[3].func_186666_e(1.5), AABB_BY_INDEX[4].func_186666_e(1.5), AABB_BY_INDEX[5].func_186666_e(1.5), AABB_BY_INDEX[6].func_186666_e(1.5), AABB_BY_INDEX[7].func_186666_e(1.5), AABB_BY_INDEX[8].func_186666_e(1.5), AABB_BY_INDEX[9].func_186666_e(1.5), AABB_BY_INDEX[10].func_186666_e(1.5), AABB_BY_INDEX[11].func_186666_e(1.5), AABB_BY_INDEX[12].func_186666_e(1.5), AABB_BY_INDEX[13].func_186666_e(1.5), AABB_BY_INDEX[14].func_186666_e(1.5), AABB_BY_INDEX[15].func_186666_e(1.5)};

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public BlockModWall(Material material) {
        super(material);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)));
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149647_a(CreativeTabs.field_78031_c);
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{UP, NORTH, SOUTH, WEST, EAST});
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P();
        state = state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf((meta >> EnumFacing.NORTH.func_176736_b() & 1) == 1));
        state = state.func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf((meta >> EnumFacing.SOUTH.func_176736_b() & 1) == 1));
        state = state.func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf((meta >> EnumFacing.WEST.func_176736_b() & 1) == 1));
        state = state.func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf((meta >> EnumFacing.EAST.func_176736_b() & 1) == 1));
        return state;
    }

    @Deprecated
    public int func_176201_c(IBlockState state) {
        int meta = 0;
        meta |= ((Boolean)state.func_177229_b((IProperty)NORTH) == true ? 1 : 0) << EnumFacing.NORTH.func_176736_b();
        meta |= ((Boolean)state.func_177229_b((IProperty)SOUTH) == true ? 1 : 0) << EnumFacing.SOUTH.func_176736_b();
        meta |= ((Boolean)state.func_177229_b((IProperty)WEST) == true ? 1 : 0) << EnumFacing.WEST.func_176736_b();
        return meta |= ((Boolean)state.func_177229_b((IProperty)EAST) == true ? 1 : 0) << EnumFacing.EAST.func_176736_b();
    }

    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = this.func_176221_a(state, source, pos);
        return AABB_BY_INDEX[this.getAABBIndex(state)];
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        if (!isActualState) {
            state = this.func_176221_a(state, (IBlockAccess)worldIn, pos);
        }
        BlockModWall.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)CLIP_AABB_BY_INDEX[this.getAABBIndex(state)]);
    }

    @Deprecated
    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        blockState = this.func_176221_a(blockState, worldIn, pos);
        return CLIP_AABB_BY_INDEX[this.getAABBIndex(blockState)];
    }

    public int getAABBIndex(IBlockState state) {
        return this.func_176201_c(state);
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean canConnectTo(IBlockAccess worldIn, BlockPos pos, EnumFacing p_176253_3_) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        BlockFaceShape blockfaceshape = iblockstate.func_193401_d(worldIn, pos, p_176253_3_);
        boolean flag = blockfaceshape == BlockFaceShape.MIDDLE_POLE_THICK || blockfaceshape == BlockFaceShape.MIDDLE_POLE && block instanceof BlockFenceGate;
        return !BlockModWall.isExcepBlockForAttachWithPiston(block) && blockfaceshape == BlockFaceShape.SOLID || flag;
    }

    public static boolean isExcepBlockForAttachWithPiston(Block p_194143_0_) {
        return Block.func_193382_c((Block)p_194143_0_) || p_194143_0_ == Blocks.field_180401_cv || p_194143_0_ == Blocks.field_150440_ba || p_194143_0_ == Blocks.field_150423_aK || p_194143_0_ == Blocks.field_150428_aP;
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN ? super.func_176225_a(blockState, blockAccess, pos, side) : true;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        boolean north = this.canWallConnectTo(worldIn, pos, EnumFacing.NORTH);
        boolean east = this.canWallConnectTo(worldIn, pos, EnumFacing.EAST);
        boolean south = this.canWallConnectTo(worldIn, pos, EnumFacing.SOUTH);
        boolean west = this.canWallConnectTo(worldIn, pos, EnumFacing.WEST);
        boolean up = north && !east && south && !west || !north && east && !south && west;
        return state.func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(!up || !worldIn.func_175623_d(pos.func_177984_a()))).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(north)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(east)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(south)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(west));
    }

    @Deprecated
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face != EnumFacing.UP && face != EnumFacing.DOWN ? BlockFaceShape.MIDDLE_POLE_THICK : BlockFaceShape.CENTER_BIG;
    }

    public boolean canBeConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return this.canConnectTo(world, pos.func_177972_a(facing), facing.func_176734_d());
    }

    public boolean canWallConnectTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        BlockPos other = pos.func_177972_a(facing);
        Block block = world.func_180495_p(other).func_177230_c();
        return block.canBeConnectedTo(world, other, facing.func_176734_d()) || this.canConnectTo(world, other, facing.func_176734_d());
    }
}

