/*
 * Decompiled with CFR 0.152.
 */
package zathrox.explorercraft.entity;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.Collection;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zathrox.explorercraft.entity.ai.EntityAIEnderreeperSwell;

public class EntityEnderreeper
extends EntityMob {
    private static final UUID ATTACKING_SPEED_BOOST_ID = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A0");
    private static final AttributeModifier ATTACKING_SPEED_BOOST = new AttributeModifier(ATTACKING_SPEED_BOOST_ID, "Attacking speed boost", (double)0.15f, 0).func_111168_a(false);
    private static final DataParameter<Integer> STATE = EntityDataManager.func_187226_a(EntityEnderreeper.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> POWERED = EntityDataManager.func_187226_a(EntityEnderreeper.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IGNITED = EntityDataManager.func_187226_a(EntityEnderreeper.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SCREAMING = EntityDataManager.func_187226_a(EntityEnderreeper.class, (DataSerializer)DataSerializers.field_187198_h);
    private int lastCreepySound;
    private int targetChangeTime;
    private int lastActiveTime;
    private int timeSinceIgnited;
    private int fuseTime = 30;
    private int explosionRadius = 5;

    public EntityEnderreeper(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.7f);
        this.field_70138_W = 1.0f;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.85f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIEnderreeperSwell(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new AIFindPlayer(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(7.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
    }

    public void func_70624_b(@Nullable EntityLivingBase entitylivingbaseIn) {
        super.func_70624_b(entitylivingbaseIn);
        IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
        if (entitylivingbaseIn == null) {
            this.targetChangeTime = 0;
            this.field_70180_af.func_187227_b(SCREAMING, (Object)false);
            iattributeinstance.func_111124_b(ATTACKING_SPEED_BOOST);
        } else {
            this.targetChangeTime = this.field_70173_aa;
            this.field_70180_af.func_187227_b(SCREAMING, (Object)true);
            if (!iattributeinstance.func_180374_a(ATTACKING_SPEED_BOOST)) {
                iattributeinstance.func_111121_a(ATTACKING_SPEED_BOOST);
            }
        }
    }

    public void playEndermanSound() {
        if (this.field_70173_aa >= this.lastCreepySound + 400) {
            this.lastCreepySound = this.field_70173_aa;
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, SoundEvents.field_187533_aW, this.func_184176_by(), 2.5f, 1.0f, false);
            }
        }
    }

    public void func_184206_a(DataParameter<?> key) {
        if (SCREAMING.equals(key) && this.isScreaming() && this.field_70170_p.field_72995_K) {
            this.playEndermanSound();
        }
        super.func_184206_a(key);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STATE, (Object)-1);
        this.field_70180_af.func_187214_a(POWERED, (Object)false);
        this.field_70180_af.func_187214_a(IGNITED, (Object)false);
        this.field_70180_af.func_187214_a(SCREAMING, (Object)false);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (((Boolean)this.field_70180_af.func_187225_a(POWERED)).booleanValue()) {
            compound.func_74757_a("powered", true);
        }
        compound.func_74777_a("Fuse", (short)this.fuseTime);
        compound.func_74774_a("ExplosionRadius", (byte)this.explosionRadius);
        compound.func_74757_a("ignited", this.hasIgnited());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(POWERED, (Object)compound.func_74767_n("powered"));
        if (compound.func_150297_b("Fuse", 99)) {
            this.fuseTime = compound.func_74765_d("Fuse");
        }
        if (compound.func_150297_b("ExplosionRadius", 99)) {
            this.explosionRadius = compound.func_74771_c("ExplosionRadius");
        }
        if (compound.func_74767_n("ignited")) {
            this.ignite();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getEnderreeperFlashIntensity(float p_70831_1_) {
        return ((float)this.lastActiveTime + (float)(this.timeSinceIgnited - this.lastActiveTime) * p_70831_1_) / (float)(this.fuseTime - 2);
    }

    public void func_70071_h_() {
        if (this.func_70089_S()) {
            int i;
            this.lastActiveTime = this.timeSinceIgnited;
            if (this.hasIgnited()) {
                this.setCreeperState(1);
            }
            if ((i = this.getCreeperState()) > 0 && this.timeSinceIgnited == 0) {
                this.func_184185_a(SoundEvents.field_187572_ar, 1.0f, 0.5f);
            }
            this.timeSinceIgnited += i;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= this.fuseTime) {
                this.timeSinceIgnited = this.fuseTime;
                this.explode();
            }
        }
        super.func_70071_h_();
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, new int[0]);
            }
        }
        if (this.hasIgnited()) {
            for (int j = 0; j < 2; ++j) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, new int[0]);
            }
        }
        this.field_70703_bu = false;
        super.func_70636_d();
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return new ResourceLocation("explorercraft", "entities/enderreeper");
    }

    protected boolean teleportRandomly() {
        double d0 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        double d1 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(64) - 32);
        double d2 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        return this.teleportTo(d0, d1, d2);
    }

    protected boolean teleportToEntity(Entity entity) {
        Vec3d vec3d = new Vec3d(this.field_70165_t - entity.field_70165_t, this.func_174813_aQ().field_72338_b + (double)(this.field_70131_O / 2.0f) - entity.field_70163_u + (double)entity.func_70047_e(), this.field_70161_v - entity.field_70161_v);
        vec3d = vec3d.func_72432_b();
        double d0 = 16.0;
        double d1 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3d.field_72450_a * 16.0;
        double d2 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(16) - 8) - vec3d.field_72448_b * 16.0;
        double d3 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3d.field_72449_c * 16.0;
        return this.teleportTo(d1, d2, d3);
    }

    private boolean teleportTo(double x, double y, double z) {
        EnderTeleportEvent event = new EnderTeleportEvent((EntityLivingBase)this, x, y, z, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        boolean flag = this.func_184595_k(event.getTargetX(), event.getTargetY(), event.getTargetZ());
        if (flag) {
            this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 1.0f);
            this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        }
        return flag;
    }

    private boolean teleportBehindEntity(Entity targetEntity) {
        Vec3d vec3d = new Vec3d(targetEntity.field_70165_t, this.func_174813_aQ().field_72338_b + (double)(this.field_70131_O / 2.0f) - targetEntity.field_70163_u + (double)targetEntity.func_70047_e(), targetEntity.field_70161_v);
        vec3d = vec3d.func_72432_b();
        for (int var3 = -1; var3 >= -5; --var3) {
            double var4 = vec3d.field_72450_a * (double)var3 + targetEntity.field_70165_t;
            double var6 = vec3d.field_72448_b;
            double var8 = vec3d.field_72449_c * (double)var3 + targetEntity.field_70161_v;
            if (!this.teleportTo(var4, var6, var8)) continue;
            return true;
        }
        return false;
    }

    private boolean switchWithEntity(Entity entity, boolean attacked, DamageSource source, float var4) {
        if (entity != null && entity instanceof EntityLiving) {
            double d1 = this.field_70165_t;
            double d2 = this.field_70163_u;
            double d3 = this.field_70161_v;
            double var11 = entity.field_70165_t;
            double var13 = entity.field_70163_u;
            double var15 = entity.field_70161_v;
            this.func_70107_b(var11, var13, var15);
            if (entity instanceof EntityPlayer) {
                ((EntityPlayer)entity).func_70634_a(d1, d2 + 2.0, d3);
            } else {
                entity.func_70107_b(d1, d2 + 2.0, d3);
            }
            return this.teleportTo(var11, var13, var15);
        }
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source instanceof EntityDamageSourceIndirect && this.switchWithEntity(source.func_76346_g(), true, source, amount)) {
            return true;
        }
        boolean flag = super.func_70097_a(source, amount);
        if (source.func_76363_c() && this.field_70146_Z.nextInt(10) != 0) {
            this.teleportRandomly();
        }
        return flag;
    }

    public boolean isScreaming() {
        return (Boolean)this.field_70180_af.func_187225_a(SCREAMING);
    }

    protected SoundEvent func_184639_G() {
        return this.isScreaming() ? SoundEvents.field_187532_aV : SoundEvents.field_187529_aS;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187570_aq;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187530_aT;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (this.field_70170_p.func_82736_K().func_82766_b("doMobLoot") && cause.func_76346_g() instanceof EntitySkeleton) {
            int i = Item.func_150891_b((Item)Items.field_151096_cd);
            int j = Item.func_150891_b((Item)Items.field_151084_co);
            int k = i + this.field_70146_Z.nextInt(j - i + 1);
            this.func_145779_a(Item.func_150899_d((int)k), 1);
        }
    }

    private boolean shouldAttackPlayer(EntityPlayer player) {
        ItemStack itemstack = (ItemStack)player.field_71071_by.field_70460_b.get(3);
        if (itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150423_aK)) {
            return false;
        }
        Vec3d vec3d = player.func_70676_i(1.0f).func_72432_b();
        Vec3d vec3d1 = new Vec3d(this.field_70165_t - player.field_70165_t, this.func_174813_aQ().field_72338_b + (double)this.func_70047_e() - (player.field_70163_u + (double)player.func_70047_e()), this.field_70161_v - player.field_70161_v);
        double d0 = vec3d1.func_72433_c();
        double d1 = vec3d.func_72430_b(vec3d1 = vec3d1.func_72432_b());
        return d1 > 1.0 - 0.025 / d0 ? player.func_70685_l((Entity)this) : false;
    }

    public boolean func_70652_k(Entity entityIn) {
        return true;
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
        super.func_70077_a(lightningBolt);
        this.field_70180_af.func_187227_b(POWERED, (Object)true);
    }

    public boolean getPowered() {
        return (Boolean)this.field_70180_af.func_187225_a(POWERED);
    }

    public float setCreeperFlashTime(float f) {
        return ((float)this.lastActiveTime + (float)(this.timeSinceIgnited - this.lastActiveTime) * f) / 28.0f;
    }

    public boolean hasIgnited() {
        return (Boolean)this.field_70180_af.func_187225_a(IGNITED);
    }

    public void ignite() {
        this.field_70180_af.func_187227_b(IGNITED, (Object)true);
    }

    public int getCreeperState() {
        return (Integer)this.field_70180_af.func_187225_a(STATE);
    }

    public void setCreeperState(int state) {
        this.field_70180_af.func_187227_b(STATE, (Object)state);
    }

    private void explode() {
        if (!this.field_70170_p.field_72995_K) {
            boolean flag = ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this);
            float f = this.getPowered() ? 2.0f : 1.0f;
            this.func_184185_a(SoundEvents.field_187532_aV, 1.0f, 0.5f);
            this.field_70729_aU = true;
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, (float)this.explosionRadius * f, flag);
            this.func_70106_y();
            this.spawnLingeringCloud();
        }
    }

    private void spawnLingeringCloud() {
        Collection collection = this.func_70651_bq();
        if (!collection.isEmpty()) {
            EntityAreaEffectCloud entityareaeffectcloud = new EntityAreaEffectCloud(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
            entityareaeffectcloud.func_184483_a(2.5f);
            entityareaeffectcloud.func_184495_b(-0.5f);
            entityareaeffectcloud.func_184485_d(10);
            entityareaeffectcloud.func_184486_b(entityareaeffectcloud.func_184489_o() / 2);
            entityareaeffectcloud.func_184487_c(-entityareaeffectcloud.func_184490_j() / (float)entityareaeffectcloud.func_184489_o());
            for (PotionEffect potioneffect : collection) {
                entityareaeffectcloud.func_184496_a(new PotionEffect(potioneffect));
            }
            this.field_70170_p.func_72838_d((Entity)entityareaeffectcloud);
        }
    }

    static class AIFindPlayer
    extends EntityAINearestAttackableTarget<EntityPlayer> {
        private final EntityEnderreeper enderreeper;
        private EntityPlayer player;
        private int aggroTime;
        private int teleportTime;

        public AIFindPlayer(EntityEnderreeper p_i45842_1_) {
            super((EntityCreature)p_i45842_1_, EntityPlayer.class, false);
            this.enderreeper = p_i45842_1_;
        }

        public boolean func_75250_a() {
            double d0 = this.func_111175_f();
            this.player = this.enderreeper.field_70170_p.func_184150_a(this.enderreeper.field_70165_t, this.enderreeper.field_70163_u, this.enderreeper.field_70161_v, d0, d0, (Function)null, (Predicate)new Predicate<EntityPlayer>(){

                public boolean apply(@Nullable EntityPlayer p_apply_1_) {
                    return p_apply_1_ != null && enderreeper.shouldAttackPlayer(p_apply_1_);
                }
            });
            return this.player != null;
        }

        public void func_75249_e() {
            this.aggroTime = 5;
            this.teleportTime = 0;
        }

        public void func_75251_c() {
            this.player = null;
            super.func_75251_c();
        }

        public boolean func_75253_b() {
            if (this.player != null) {
                if (!this.enderreeper.shouldAttackPlayer(this.player)) {
                    return false;
                }
                this.enderreeper.func_70625_a((Entity)this.player, 10.0f, 10.0f);
                return true;
            }
            return this.field_75309_a != null && ((EntityPlayer)this.field_75309_a).func_70089_S() ? true : super.func_75253_b();
        }

        public void func_75246_d() {
            if (this.player != null) {
                if (--this.aggroTime <= 0) {
                    this.field_75309_a = this.player;
                    this.player = null;
                    super.func_75249_e();
                }
            } else {
                if (this.field_75309_a != null) {
                    if (this.enderreeper.shouldAttackPlayer((EntityPlayer)this.field_75309_a)) {
                        if (((EntityPlayer)this.field_75309_a).func_70068_e((Entity)this.enderreeper) < 16.0) {
                            this.enderreeper.teleportRandomly();
                        }
                        this.teleportTime = 0;
                    } else if (((EntityPlayer)this.field_75309_a).func_70068_e((Entity)this.enderreeper) > 256.0 && this.teleportTime++ >= 30 && this.enderreeper.teleportToEntity((Entity)this.field_75309_a)) {
                        this.teleportTime = 0;
                    }
                }
                super.func_75246_d();
            }
        }
    }
}

