/*
 * Decompiled with CFR 0.152.
 */
package zathrox.explorercraft.init;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zathrox.explorercraft.init.BlockReg;

@SideOnly(value=Side.CLIENT)
public class ColourRegistry {
    private static final Minecraft minecraft = Minecraft.func_71410_x();

    public static void init() {
        BlockColors blockColors = minecraft.func_184125_al();
        ItemColors itemColors = minecraft.getItemColors();
        ColourRegistry.registerBlockColourHandlers(blockColors);
        ColourRegistry.registerItemColourHandlers(blockColors, itemColors);
    }

    private static void registerBlockColourHandlers(BlockColors blockColors) {
        IBlockColor grassColourHandler = (state, blockAccess, pos, tintIndex) -> {
            if (blockAccess != null && pos != null) {
                return BiomeColorHelper.func_180287_b((IBlockAccess)blockAccess, (BlockPos)pos);
            }
            return ColorizerGrass.func_77480_a((double)0.5, (double)1.0);
        };
        IBlockColor waterColourHandler = (state, blockAccess, pos, tintIndex) -> BiomeColorHelper.func_180288_c((IBlockAccess)blockAccess, (BlockPos)pos);
        blockColors.func_186722_a(grassColourHandler, new Block[]{BlockReg.BAMBOO_LEAVES});
        blockColors.func_186722_a(waterColourHandler, new Block[]{BlockReg.RICE_BASE});
        blockColors.func_186722_a(grassColourHandler, new Block[]{BlockReg.WATER_GRASS});
    }

    private static void registerItemColourHandlers(BlockColors blockColors, ItemColors itemColors) {
        IItemColor itemBlockColourHandler = (stack, tintIndex) -> {
            IBlockState iblockstate = ((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77960_j());
            return blockColors.func_186724_a(iblockstate, null, null, tintIndex);
        };
        itemColors.func_186731_a(itemBlockColourHandler, new Block[]{BlockReg.BAMBOO_LEAVES});
        itemColors.func_186731_a(itemBlockColourHandler, new Block[]{BlockReg.WATER_GRASS});
    }
}

